CREATE TEMPORARY TABLE go_slims_counts
SELECT go_slims.go_acc, COUNT(DISTINCT search_hit.query_id) AS subtotal
FROM   go_slims
       INNER JOIN go_tc ON (go_slims.go_acc = go_tc.parent)
       INNER JOIN go_assoc ON (go_tc.child = go_assoc.go_acc)
       INNER JOIN annot AS a1 ON (go_assoc.acc = a1.acc)
       INNER JOIN annot AS a2 ON (a1.prot_id = a2.prot_id)
       INNER JOIN search_lib ON (a2.gi = search_lib.seq_id)
       INNER JOIN search_hit USING (lib_id)
       INNER JOIN search USING (search_id)
WHERE  go_slims.name = "generic"
  AND  search.tag = "eco-go"
  AND  search_hit.expect <= 1e-10
GROUP BY go.go_acc;

SELECT go.go_acc, go.name, IFNULL(subtotal, 0) AS subtotal
FROM   go_slims
       INNER JOIN go USING (go_acc)
       LEFT JOIN go_slims_counts USING (go_acc)
WHERE  go_slims.name = "generic"
ORDER BY go_slims.rank;
