
CREATE USER seqdb_demo WITH PASSWORD 'seqdb_pass';

--
-- Table structure for table 'protein'
--

CREATE TABLE protein (
  prot_id serial PRIMARY KEY,
  seq text NOT NULL default '',
  len integer NOT NULL default '0',
  pi real NOT NULL default '0',
  mw real NOT NULL default '0'
);

CREATE INDEX prot_len ON protein (len);
CREATE INDEX prot_pi ON protein (pi);
CREATE INDEX prot_mw ON protein (mw);

--
-- Table structure for table 'taxon_gc'
--

CREATE TABLE taxon_gc (
  gc_id integer NOT NULL default '0',
  name varchar(128),
  cde varchar(64) default NULL,
  starts varchar(64) default NULL,
  PRIMARY KEY  (gc_id)
);

--
-- Table structure for table 'taxon'
--

CREATE TABLE taxon (
  taxon_id integer NOT NULL default '0',
  parent_id integer NOT NULL default '0',
  left_id integer NOT NULL default '0',
  right_id integer NOT NULL default '0',
  rank VARCHAR(50) NOT NULL default 'no rank',
  gc_id integer REFERENCES taxon_gc (gc_id),
  mgc_id integer REFERENCES taxon_gc (gc_id),
  PRIMARY KEY  (taxon_id)
);

CREATE INDEX taxon_parent_id ON taxon (parent_id);
CREATE INDEX taxon_left_id ON taxon (left_id);
CREATE INDEX taxon_right_id ON taxon (right_id);
CREATE INDEX taxon_rank ON taxon (rank);
CREATE INDEX taxon_gc_id ON taxon (gc_id);
CREATE INDEX taxon_mgc_id ON taxon (mgc_id);


--
-- Table structure for table 'annot'
--

CREATE TABLE annot (
  acc char(20) NOT NULL default '' PRIMARY KEY,
  ver smallint not null default 1,
  gi integer default NULL,
  prot_id integer REFERENCES protein (prot_id),
  taxon_id integer REFERENCES taxon (taxon_id),
  db varchar(3) NOT NULL default 'gb',
  descr text NOT NULL default '',
  pref smallint NOT NULL default '0'
);

CREATE INDEX annot_gi ON annot (gi);
CREATE INDEX annot_prot_id ON annot (prot_id);
CREATE INDEX annot_taxon_id ON annot (taxon_id);
CREATE INDEX annot_db ON annot (db);
CREATE INDEX annot_pref ON annot (pref);

--
-- Table structure for table 'annot_dbj'
--

CREATE TABLE annot_dbj (
  acc char(20) NOT NULL default '',
  ver smallint not null default 1,
  dna_acc char(20) NOT NULL default '',
  PRIMARY KEY  (acc, ver)
);

--
-- Table structure for table 'annot_emb'
--

CREATE TABLE annot_emb (
  acc char(20) NOT NULL default '',
  ver smallint not null default 1,
  dna_acc char(20) NOT NULL default '',
  PRIMARY KEY  (acc, ver)
);

--
-- Table structure for table 'annot_gb'
--

CREATE TABLE annot_gb (
  acc char(20) NOT NULL default '',
  ver smallint not null default 1,
  dna_acc char(20) NOT NULL default '',
  PRIMARY KEY  (acc, ver)
);

--
-- Table structure for table 'annot_ref'
--

CREATE TABLE annot_ref (
  acc char(20) NOT NULL default '',
  ver smallint not null default 1,
  dna_acc char(20) NOT NULL default '',
  PRIMARY KEY  (acc, ver)
);

--
-- Table structure for table 'annot_tpg'
--

CREATE TABLE annot_tpg (
  acc char(20) NOT NULL default '',
  ver smallint not null default 1,
  dna_acc char(20) NOT NULL default '',
  PRIMARY KEY  (acc, ver)
);

--
-- Table structure for table 'annot_sp'
--

CREATE TABLE annot_sp (
  acc char(20) NOT NULL default '',
  ver smallint not null default 1,
  name char(10) NOT NULL default '',
  PRIMARY KEY  (acc, ver)
);

CREATE INDEX annot_sp_name ON annot_sp (name);

--
-- Table structure for table 'taxon_name'
--

CREATE TABLE taxon_name (
  id serial,
  taxon_id integer REFERENCES taxon (taxon_id),
  name text NOT NULL default '',
  class varchar(50) NOT NULL default 'common name',
  PRIMARY KEY  (id)
);

CREATE INDEX taxname_class ON taxon_name (class);


--
-- Table structure for table 'annot_old'
--

CREATE TABLE annot_old (
  acc char(20) NOT NULL default '',
  ver smallint not null default 1,
  gi integer default NULL,
  prot_id integer NOT NULL default '0',
  taxon_id integer default NULL,
  db VARCHAR(3) NOT NULL default 'gb',
  descr text NOT NULL default '',
  PRIMARY KEY  (acc, ver)
);

CREATE INDEX annot_old_gi ON annot_old (gi);
CREATE INDEX annot_old_prot_id ON annot_old (prot_id);
CREATE INDEX annot_old_taxon_id ON annot_old (taxon_id);
CREATE INDEX annot_old_db ON annot_old (db);
