
DROP TABLE IF EXISTS hitranges;
CREATE TABLE hitranges TYPE=HEAP
SELECT search_lib.seq_id AS query_id, 
       IF(strand = 'f', lbegin, lend) AS begin, 
       IF(strand = 'f', lend, lbegin) AS end
FROM   search 
       INNER JOIN search_hit USING (search_id)
       INNER JOIN search_lib USING (lib_id)
WHERE  search.tag = 'eco-vs-stm'
  AND  search_hit.expect <= 1e-10;

CREATE TEMPORARY TABLE igranges TYPE=HEAP
SELECT hrA.query_id AS query_id, 
       MAX(hrA.end + 1) AS begin, 
       MIN(hrB.begin - 1) AS end
FROM   hitranges AS hrA 
       INNER JOIN hitranges AS hrB
         ON (hrA.query_id = hrB.query_id AND hrB.begin > hrA.end)
GROUP BY hrA.query_id, hrA.begin;

INSERT INTO igranges (query_id, begin, end) 
SELECT query_id AS query_id,  
       1 AS begin,  
       MIN(begin - 1) AS end
FROM   hitranges
GROUP BY query_id
HAVING end >= begin;

INSERT INTO igranges (query_id, begin, end)
SELECT hitranges.query_id AS query_id,  
       MAX(hitranges.end + 1) AS begin,
       search_lib.len AS end
FROM   hitranges 
       INNER JOIN search_lib ON (search_lib.seq_id = query_id)
       INNER JOIN search USING (search_id)
WHERE  tag = "eco-vs-stm"
GROUP BY hitranges.query_id
HAVING end >= begin;

CREATE TEMPORARY TABLE missing TYPE=HEAP
SELECT search_lib.seq_id AS query_id, 
       1 AS begin, 
       search_lib.len AS end
FROM   search_lib
       INNER JOIN search USING (search_id)
       LEFT JOIN hitranges ON (search_lib.seq_id = hitranges.query_id)
WHERE  tag = "eco-vs-stm"
  AND  hitranges.query_id IS NULL;

INSERT INTO igranges (query_id, begin, end)
SELECT query_id, begin, end
FROM   missing;


