

DROP TABLE IF EXISTS temp_results;
CREATE TEMPORARY TABLE temp_results (
  query_id  INT UNSIGNED NOT NULL DEFAULT 0, 
  taxon_id INT UNSIGNED NOT NULL DEFAULT 0, 
  PRIMARY KEY (query_id, taxon_id)
) TYPE = HEAP;

INSERT INTO temp_results ( query_id, taxon_id ) 
SELECT search_query.seq_id, kingdom.taxon_id
FROM   search 
       INNER JOIN search_query USING (search_id)
       INNER JOIN search_hit USING (query_id)
       INNER JOIN search_lib USING (lib_id)
       INNER JOIN annot ON (search_lib.seq_id = annot.gi)
       INNER JOIN taxon USING (taxon_id)
       INNER JOIN taxon AS kingdom ON (taxon.left_id BETWEEN kingdom.left_id AND kingdom.right_id)
       INNER JOIN taxon_name ON (kingdom.taxon_id = taxon_name.taxon_id AND
                                 taxon_name.class = 'scientific name')

       INNER JOIN taxon AS entero ON (taxon.left_id NOT BETWEEN entero.left_id AND entero.right_id)
       INNER JOIN taxon_name AS entero_name ON (entero.taxon_id = entero_name.taxon_id AND
                                                entero_name.class = 'scientific name')

WHERE  taxon_name.name IN ('Bacteria', 'Eukaryota', 'Archaea')
  AND  entero_name.name = 'Escherichia coli'
  AND  search.tag = 'eco-vs-nr'
;

DROP TABLE IF EXISTS exclude; 
CREATE TEMPORARY TABLE exclude TYPE = HEAP
SELECT DISTINCT(query_id) AS query_id
FROM   temp_results 
       INNER JOIN taxon USING (taxon_id)
       INNER JOIN taxon_name ON
         (taxon.taxon_id = taxon_name.taxon_id AND
          taxon_name.class = 'scientific name')
WHERE  taxon_name.name NOT IN ('Archaea', 'Bacteria');

SELECT COUNT(temp_results.query_id) AS total, annot.descr
FROM   temp_results
       INNER JOIN taxon USING (taxon_id)
       INNER JOIN taxon_name ON
         (taxon.taxon_id = taxon_name.taxon_id AND
          taxon_name.class = 'scientific name')
       INNER JOIN annot ON (temp_results.query_id = annot.gi)
       LEFT JOIN exclude ON (temp_results.query_id = exclude.query_id)
WHERE  exclude.query_id IS NULL
  AND  taxon_name.name IN ('Archaea', 'Bacteria')
GROUP BY temp_results.query_id
HAVING total = 2
ORDER BY descr
;
