
/****************************************************************************** 
 * 
 *  file:  Element.h
 * 
 *  Copyright (c) 2003,  University of Virginia..
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 



#ifndef ELEMENT_H
#define ELEMENT_H

#include <string>
#include <vector>
#include <algorithm>
#include <iostream>
#include <GenericException.h>
#include <Tostring.h>

namespace NOPT {
/**
 * A class representing an element on the Waterman-Byers stack.
 * A rather simple (dumb) class that holds the data of an element on the
 * Waterman-Byers stack.
 */
class Element 
{
	public:
		
		/**
		 * Constructor.
		 * Just assigns all of the appropriate values.
		 * \param int curr_i - The current down index.
		 * \param int curr_j - The current across index.
		 * \param int next_i - The next down index.
		 * \param int next_j - The next across index.
		 * \param int score - The running score of the stack.
		 * \param int direction - The direction that we just came from. The
		 * int values are specified in AlignmentGenerator.h.
		 * \param int len - The length of the current alignment.  Used
		 * for truncating the sequence once an alignment has been created
		 * and we are moving down the stack.
		 */
		Element(int curr_i, int curr_j, int next_i, int next_j,  
						int score, int dir, int len ) 
		 : _current_i(curr_i),
		   _current_j(curr_j),
		   _next_i(next_i),
		   _next_j(next_j),
		   _score(score),
		   _direction( dir ),
		   _seqLength( len )
		 {};

		/**
		 * Returns the next down index.
		 */ 
		int getNextI() { return _next_i; };

		/**
		 * Returns the next across index.
		 */ 
		int getNextJ() { return _next_j; };

		/**
		 * Returns the current down index.
		 */ 
		int getCurrentI() { return _current_i; };

		/**
		 * Returns the current across index.
		 */ 
		int getCurrentJ() { return _current_j; };

		/**
		 * Returns the running score of the stack.
		 */ 
		int getScore() { return _score; };

		/**
		 * Returns the direction we came from.
		 */ 
		int getDirection() { return _direction; };

		/**
		 * Returns the sequence length. 
		 */ 
		int getSeqLength() { return _seqLength; };

	protected:

		/**
		 * The current down index. 
		 */ 
		int _current_i; 

		/**
		 * The current across index. 
		 */ 
		int _current_j; 

		/**
		 * The next down index. 
		 */ 
		int _next_i; 

		/**
		 * The next across index. 
		 */ 
		int _next_j; 

		/**
		 * The sequence length. 
		 */ 
		int _score;

		/**
		 * The running score of the stack to this point. 
		 */ 
		int _direction;

		/**
		 * The sequence length. 
		 */ 
		int _seqLength;

};

}

#endif

