
/****************************************************************************** 
 * 
 *  file:  MyersMillerGenerator.h
 * 
 *  Copyright (c) 2003,  University of Virginia..
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#ifndef MYERSMILLERGENERATOR_H
#define MYERSMILLERGENERATOR_H

#include <string>
#include <fstream>
#include <vector>
#include "AlignmentGenerator.h" 

using namespace std;

namespace NOPT {

class MyersMillerGenerator : public AlignmentGenerator
{
	public:
		MyersMillerGenerator(int gapCreate,
						     int gapExtend,
						     ScoringMatrix* pam,
						     bool isDNA,
						     const string& seq1,
						     const string& seq2,
						     int debug,
						     bool local);

		~MyersMillerGenerator();

		void getAscii(bool compress = true) ;

	private:

		void _generate();

		int _align(const string& s1, const string& s2, int tb, int te);

		inline void del(int x);
		inline void ins(int x);
		inline int gap(int x);
		inline void rep();
		

		vector<int> CC;
		vector<int> DD;
		vector<int> RR;
		vector<int> SS;

		vector<int> _resultScript;
		int _lastOp;
		int _scriptIndex;
};

}

#endif
