
/****************************************************************************** 
 * 
 *  file:  WatermanByersGenerator.h
 * 
 *  Copyright (c) 2003,  University of Virginia..
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#ifndef WATERMANBYERSGENERATOR_H
#define WATERMANBYERSGENERATOR_H

#include <string>
#include <cstdlib>
#include <algorithm>
#include <fstream>
#include <vector>
#include <stack>
#include <list>
#include <ScoringMatrix.h> 
#include <GenericException.h> 
#include <XMLable.h> 
#include <XML.h> 
#include <Tostring.h> 
#include <time.h> 
#include "Alignment.h" 
#include "Whence.h" 
#include "Element.h" 
#include "AlignmentGenerator.h" 

using namespace std;

namespace NOPT {

/**
 * A class to generate all near optimal alignments.
 * Uses the Waterman-Byers algorithm to generate all alignments within a
 * neighborhood of optimal.  See (ref).
 */
class WatermanByersGenerator : public AlignmentGenerator
{
	public:
				
		/**
		 *
		 */
		WatermanByersGenerator(int gapCreate, int gapExtend, ScoringMatrix* pam,
						   bool isDNA, const string& seq1, 
						   const string& seq2, float lowerbound, 
						   float upperbound, int debug, bool local );

		/**
		 * Destructor.
		 */
		~WatermanByersGenerator();

		/**
		 * Writes alignments generated to stdout.
		 * Whereas other getAscii() methods iterate over a list of alignments
		 * created, this is actually the method that generates the alignments.
		 * It writes the alignments to stdout one at a time as they are 
		 * created.  This is because of the extremely large number of 
		 * alignments that can be created.
		 */
		void getAscii(bool compress = true);

		/**
		 * Returns false since WatermanByers can't do xml.
		 */
		bool xmlable() const;
	
	private:

		void _generate(bool uncompress);
		string _getAscii(const Alignment& a, 
				         int num, 
						 bool compress = true) const;
		void _createMatrices();
		void _processElement(bool uncompress);
		void _doCounts();

		//
		// Other values.
		//
		string _currentSeq1;
		string _currentSeq2;

		vector< vector<int> > _fMatrix;
		stack<Element*> _stack;

};

}

#endif
