
/****************************************************************************** 
 * 
 *  file:  ScoringMatrix.h
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#ifndef __SCORINGMATRIX_H
#define __SCORINGMATRIX_H

#include <string>
#include <map>
#include <cctype>
#include <algorithm>
#include <iostream>
#include "GenericException.h" 
#include "Tostring.h" 
#include "BLAST_ScoringMatrices.h"
#include "FASTA_ScoringMatrices.h"

using namespace std;

namespace NOPT {

class ScoringMatrix
{
    public:
		ScoringMatrix(const string& name);
		ScoringMatrix(const ScoringMatrix& s);
		ScoringMatrix& ScoringMatrix::operator=(const ScoringMatrix& s);
		~ScoringMatrix(){};

		string name() { return _matrixName; };
		string alphabet() { return _alphabet; };

		int score(char a, char b);

	private:
		map<char, map<char, int> > _pam;
		string _matrixName;
		string _alphabet;
		bool _defaultChar;

		void _createPam(const int* mat, const char* al);
};

}

#endif

