
/****************************************************************************** 
 * 
 *  file:  SequenceReader.h
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#ifndef SEQUENCEREADER_H
#define SEQUENCEREADER_H

#include <vector>
#include <string>
#include <fstream>
#include <GenericException.h> 

using namespace std;

namespace NOPT {

//--------------------------------------------------------------------------
// Some simple static methods for reading fasta files
//--------------------------------------------------------------------------
class SequenceReader
{

	public:

		static void readFasta( const string& filename, 
						       string& seq, 
							   string& header );

		static void readMultipleFasta( const string& filename, 
				                       vector<string>& seq, 
							           vector<string>& header );
		static void readMultiplePir( const string& filename, 
				                       vector<string>& seq, 
							           vector<string>& header );

};

}

#endif

