
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/actions/AddOptionSetAction.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 



package edu.virginia.bioch.nopt.actions;


import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.display.path.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.*;
import edu.virginia.bioch.scoringmatrices.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;
import java.beans.*;

public class AddOptionSetAction
	extends AbstractAction
	implements PropertyChangeListener
{
	protected Component com;
	protected OptionTableModel otm;
	
	public AddOptionSetAction( Component c )//, OptionTableModel o )
	{ 
		super("Add Annotation Set");
		com = c;
		otm = null;

		// can't create options until we have seqs
		setEnabled( false );  
	}

	public void propertyChange( PropertyChangeEvent e )
	{
		if ( e.getPropertyName().equals( "setSeqCompare" ) )
		{
			otm = ( (SeqCompare)e.getNewValue()).getOptionTableModel();
			setEnabled( true );
		}
	}

	public void actionPerformed( ActionEvent e )
	{

		JFileChooser fc = new JFileChooser();
       	fc.setApproveButtonText("Load GFF File");
		int returnVal = fc.showOpenDialog(com);
		if (returnVal == JFileChooser.APPROVE_OPTION)
		{
			try {

			OptionSetReader or = new OptionSetReader( fc.getSelectedFile() );
			otm.addRows( or.getOptionMap() );

			} catch ( Exception ex )
			{
				ex.printStackTrace();
				JOptionPane.showMessageDialog( com,
                                "Error reading annotation set!  " +
                                ex.getMessage(),
                                "Error reading annotation set",
                                JOptionPane.ERROR_MESSAGE );
			}
		}
	}
}
