
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/actions/SVGGenerator.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.actions;


import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGeneratorContext;
import java.awt.geom.Point2D;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;

/*
 * This class overrides SVGGraphics2D doesn't implement drawGlyphVector
 * in a sensible way.  It treats the entire GlyphVector as a single shape
 * which makes for some ugly and essentially unusable XML.  
 *
 * However, the way this class handles GlyphVectors is a huge and ugly hack.
 * Treating each character in the GlyphVector as a String is OK, but getting
 * the character out of the GlyphVector is not something that was apparently
 * ever intended, and hence the ugly charMap thing.
 */
public class SVGGenerator extends SVGGraphics2D
{
	public SVGGenerator(SVGGeneratorContext context, boolean textAsShapes)
	{
		super(context, textAsShapes);
	}
	
	public void drawGlyphVector(GlyphVector gv, float x, float y) 
	{
        if (!textAsShapes) 
		{
            String[] charMap = getCharMap( gv );
            int num = gv.getNumGlyphs();
            for ( int i = 0; i < num; i++ )
            {
                int gc = gv.getGlyphCode(i);

				// By treating each glyph as a shape, the XML doesn't 
				// tell us what the char is.  Not ideal.
                // Shape s = gv.getGlyphOutline( i, x, y);
                // fill(s);

                Point2D p = gv.getGlyphPosition( i );
                drawString( charMap[ gc ], x+(float)p.getX(),
                                           y+(float)p.getY() );
            }
        } 
		else 
            super.drawGlyphVector(gv, x, y);
    }

	// This is a stupendously ugly hack... but it seems to work.
    protected String[] getCharMap( GlyphVector gv ) 
	{
        Font f = gv.getFont();
        FontRenderContext frc = gv.getFontRenderContext();
        String key = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-=[];',./`!@#$%^&*()_+{}|?><~ ";
        String[] map = new String[1000];

        GlyphVector newGV = f.createGlyphVector( frc, key );

        for ( int i = 0; i < newGV.getNumGlyphs(); i++)
        {
            int gc = newGV.getGlyphCode(i);
            map[gc] = key.substring(i,i+1);
        }
        return map;
    }
}
