
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/alignments/AlignmentHandler.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.alignments;



import java.util.*;
import java.lang.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;                                                   
import javax.swing.*;
import javax.swing.event.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.scoringmatrices.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.actions.*;
import edu.virginia.bioch.nopt.conditions.*;


public class AlignmentHandler
	implements EdgeContainer, Reinitializable
{

	protected int _maxLength;
	protected int _maxCount;
	protected HashMap _rp;
	protected HashMap _counts;
	protected HashMap _keyMap;
	protected HashMap _params;
	protected String _plainSeq1;
	protected String _plainSeq2;
	protected String _seq1Name;
	protected String _seq2Name;
	protected String _seq1Desc;
	protected String _seq2Desc;
	protected String _order; 
	protected int _curr; 
	protected boolean _isDna; 
	protected Vector _a; 
	protected float _optimalPercentSimilarity; 
	protected float _optimalPercentIdentity; 
	protected HashMap _scoringMatrixMap; 
	protected Map _config; 
	protected Alignment _currentAlignment;

	// Dummy constructor. 
	// Don't use this for anything.
	// (Unless you know what you're doing).
	public AlignmentHandler( )
	{
		_a = new Vector();
		_curr = 0;
		_maxCount = 0;
		_maxLength = 0;
		_rp = new HashMap();
		_counts = new HashMap();
		_keyMap = new HashMap();
		_order = "";
		_optimalPercentSimilarity = 0; 
		_optimalPercentIdentity = 0; 
		_isDna = false;
		_scoringMatrixMap = new HashMap();
		_plainSeq1 = ""; 
		_plainSeq2 = ""; 
		_seq1Desc = ""; 
		_seq2Desc = ""; 
		_seq1Name = ""; 
		_seq2Name = ""; 
		_order = ""; 
		_currentAlignment = null;
	}

	public AlignmentHandler( Map config )
		throws Exception
	{
		_config = config;
		_a = new Vector();
		_curr = 0;
		_maxCount = 0;
		_maxLength = 0;
		_rp = new HashMap();
		_counts = new HashMap();
		_keyMap = new HashMap();
		_params = new HashMap();
		_order = "";
		_optimalPercentSimilarity = 0; 
		_optimalPercentIdentity = 0; 
		_isDna = false;
		_scoringMatrixMap = new HashMap();

		// quick sanity check
		if ( !config.containsKey( "seq1" ) ||
			 !config.containsKey( "seq2" ) ||
			 !config.containsKey( "totalNumAlignments" ) )
			throw new Exception("Alignment set not properly formatted! Missing"
		            + " seq1, seq2, or totalNumAlignments lines.");

		_plainSeq1 = (String)config.get("seq1");
		_plainSeq2 = (String)config.get("seq2");
		String temp = (String)config.get("totalNumAlignments");
		int numAlignments = Integer.parseInt( temp ); 

		if ( config.containsKey( "numParameters" ) )
		{
			int np = Integer.parseInt((String)config.get("numParameters"));
			for ( int i = 0; i < np; i++ )
			{
				String key = "parameters_" + Integer.toString(i);
				if ( !config.containsKey( key ) )
					throw new Exception("Missing parameters: " + key );

				addParameters((String)(config.get( "parameters_" + 
												    Integer.toString(i) )));
			}
		}
		else
		{
			if ( !config.containsKey( "parameters" ) )
				throw new Exception("Missing parameters!");

			addParameters((String)(config.get( "parameters" ) )); 
		}

		if ( config.containsKey( "seq1Description" ) )
			_seq1Desc = (String)config.get("seq1Description"); 
		else
			_seq1Desc = "seq1 no description provided";

		if ( config.containsKey( "seq2Description" ) )
			_seq2Desc = (String)config.get("seq2Description"); 
		else
			_seq2Desc = "seq2 no description provided";

		if ( config.containsKey( "seq1Name" ) )
			_seq1Name = (String)config.get("seq1Name"); 
		else
			_seq1Name = "seq1 no name provided";

		if ( config.containsKey( "seq2Name" ) )
			_seq2Name = (String)config.get("seq2Name"); 
		else
			_seq2Name = "seq2 no name provided";

		for ( int i = 0; i < numAlignments; i++ )
		{
			temp = (String)config.get("a_" + i );
			try
			{
				if ( temp != null )
					_a.add( new Alignment(temp, this) );
			}
			catch (Exception e)
			{
				System.out.println("Skipping alignment create exception " +
						i + " " + e.toString() );
						e.printStackTrace();
			}
		}

		_currentAlignment = (Alignment)(_a.get(_curr));
	}


	//public ScoringMatrix getSetScoringMatrix( String key )
	public AlignmentParameters getAlignmentParameters( String key )
		throws Exception
	{

		if ( !_params.containsKey( key ) )
			throw new Exception("Couldn't find param key: " + key );

		return (AlignmentParameters)_params.get(key);
	}

	public Alignment getCurrentAlignment()
	{ return _currentAlignment; }

	// For the EdgeContainer interface
	public Vector getCurrentEdges()
	{
		return _currentAlignment.getEdges(); 
	}

	public int getCurrentIndex() { return _curr; }

	public Set getAllEdges()
	{ return _rp.keySet(); }

	public void addAlignment( Alignment a )
	{ _a.add( a ); }

	public Vector getAlignments()
	{ return _a; }
	
	public int getNumAlignments()
	{ return _a.size(); }

	public String getOrder()
	{ return _order; } 

	public void setOrder(String o)
	{ _order = o; } 

	public void incrementCurrent(ConditionHandler ch) 
	{ 
		int safety = _a.size();
		do
		{
			_curr++; 
			if ( _curr >= _a.size() )
				_curr = 0;

			if ( safety-- < 0 )
			{
				System.out.println("Bad condition selected!  " +
								   "Unselect it to continue." );
				_curr = 0;
				break;
			}
		}
		while ( !ch.conditionsMet( _curr ) );
		_currentAlignment = (Alignment)(_a.get(_curr));
	}

    public void decrementCurrent(ConditionHandler ch)
	{
		int safety = _a.size();
		do
		{
			_curr--;
			if (_curr <= 0)
				_curr = _a.size() - 1;

			if ( safety-- < 0 )
			{
				System.out.println("Bad condition selected!  " +
								   "Unselect it to continue." );
				_curr = 0;
				break;
			}
		}
		while ( !ch.conditionsMet( _curr ) );
		_currentAlignment = (Alignment)(_a.get(_curr));
	}

	public void setCurrent(int x)
	{
		if (x < 0)
			_curr = 0;
		else if (x >= _a.size())
			_curr = _a.size() - 1;
		else
			_curr = x;

		_currentAlignment = (Alignment)(_a.get(_curr));
	}


	public float getOptimalPercentIdentity()
	{ return _optimalPercentIdentity; }

	public float getOptimalPercentSimilarity()
	{ return _optimalPercentSimilarity; }

	public void setPlainSeq1( String s1 ) { _plainSeq1 = s1; }
	public void setPlainSeq2( String s2 ) { _plainSeq2 = s2; }

	public void setSeq1Name( String s1 ) { _seq1Name = s1; }
	public void setSeq2Name( String s2 ) { _seq2Name = s2; }

	public void setSeq1Description( String s1 ) { _seq1Desc = s1; }
	public void setSeq2Description( String s2 ) { _seq2Desc = s2; }

	public String getPlainSeq1() { return _plainSeq1; }
	public String getPlainSeq2() { return _plainSeq2; }

	public String getSeq1Name() { return _seq1Name; }
	public String getSeq2Name() { return _seq2Name; }

	public String getSeq1Description() { return _seq1Desc; } 
	public String getSeq2Description() { return _seq2Desc; }

	public int getCountSize()
	{
		return _counts.size();
	}

	public int getCount( EdgeKey key )
	{
		Counter c = (Counter)(_counts.get(key));
		return c.getCount();
	}
								 
	public double getRelativePosition( EdgeKey key )
	{
		return ((CumulativePosition)_rp.get(key)).getCumulativePosition();
	}

	public int getMaxCount()
	{ return _maxCount; }

	public int getMaxLength() { return _maxLength; }

	public void updateMaxLength( int newLen ) 
	{ 
		_maxLength = Math.max( newLen, _maxLength ); 
	}

	public EdgeKey updateEdges( EdgeKey key, double relPos )
	{
		if ( _counts.containsKey( key ) && _rp.containsKey( key ) )
		{
			Counter ct = (Counter)_counts.get( key );
			ct.increment();
			_maxCount = Math.max( _maxCount, ct.getCount() ); 
			((CumulativePosition)_rp.get( key )).update( relPos );

			return (EdgeKey)_keyMap.get( key );
		}
		else
		{
			EdgeKey newKey = (EdgeKey)key.clone();
			_counts.put( newKey, new Counter( 1 ) );
			_rp.put( newKey, new CumulativePosition( relPos ) );
				
			_keyMap.put( newKey, newKey );

			return newKey;
		}
	}

	public void updatePercentIdentity( float percentIdentity ) 
	{
		_optimalPercentIdentity = Math.max( _optimalPercentIdentity,
					                        percentIdentity );
	}

	public void updatePercentSimilarity( float percentSimilarity ) 
	{
		_optimalPercentSimilarity = Math.max( _optimalPercentSimilarity,
					                        percentSimilarity );
	}

	public Map getConfig()
	{
		return _config;
	}

	public void reinitialize()
	{
	}

	protected void addParameters( String s )
	{
		try {
		AlignmentParameters ap = new AlignmentParameters( s );
		_params.put( ap.getKey(), ap );
		} catch (Exception e) { e.printStackTrace(); }
	}

	public Map getParams()
	{
		return _params;
	}
}

		
