

/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/alignments/Alignment.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.alignments;



import java.util.*;
import java.lang.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;                                                   
import javax.swing.*;
import javax.swing.event.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.scoringmatrices.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.conditions.*;
import edu.virginia.bioch.nopt.alignments.*;


public class AlignmentParameters
{
	protected Map valMap; 
	protected String key;
	protected ScoringMatrix sm;

	//
	// Constructor
	//
	public AlignmentParameters(String s)
		throws Exception
	{
		System.out.println("AlignmentParameters constructor");
		
		valMap = new HashMap();

		if ( s != null )
		{
			StringTokenizer t = new StringTokenizer(s,"|");
			key = t.nextToken();
		
			while ( t.hasMoreTokens() )
			{
				StringTokenizer tt = new StringTokenizer( t.nextToken(), "=");
				String name = tt.nextToken();
				String value = tt.nextToken();
				valMap.put(name,value);
			}
		}
		else
		{
			throw new Exception("No param string for AlignmentParameters!");
		}

		sm = new ScoringMatrix( (String)(valMap.get("scoringMatrix")) );
	} 

	public String getKey()
	{ return key; }

	public int getGapCreate() 
	{ return Integer.parseInt((String)(valMap.get("gapCreate"))); }

	public int getGapExtend() 
	{ return Integer.parseInt((String)(valMap.get("gapExtend"))); }

	public String getScoringMatrixName() 
	{ return (String)(valMap.get("scoringMatrix")); }

	public ScoringMatrix getScoringMatrix() 
	{ return sm; }

	public int getOptimalScore() 
	{ return Integer.parseInt((String)(valMap.get("optimalScore"))); }

	public float getLowerBoundPercent() 
	{ return Float.parseFloat((String)(valMap.get("lowerBoundPercent"))); }

	public float getUpperBoundPercent() 
	{ return Float.parseFloat((String)(valMap.get("upperBoundPercent"))); }

	public int getLowerBound() 
	{ return Integer.parseInt((String)(valMap.get("lowerBound"))); }

	public int getUpperBound() 
	{ return Integer.parseInt((String)(valMap.get("upperBound"))); }

	public boolean isDNA()
	{
		int x = Integer.parseInt((String)(valMap.get("dna")));
		if ( x == 0 )
			return false;
		else
			return true;
	}

	public boolean isLocal()
	{
		int x = Integer.parseInt((String)(valMap.get("local")));
		if ( x == 0 )
			return false;
		else
			return true;
	}

	public String getAlgorithmName()
	{ return (String)(valMap.get("algorithm")); }
}
