
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/alignments/AlignmentSetReader.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.alignments;



import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;
import java.io.IOException;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.scoringmatrices.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;

public class AlignmentSetReader 
{
	protected HashMap alignmentMap;

	public AlignmentSetReader( BufferedReader input ) 
	{
		System.out.println("AlignmentSetReader constructor");
		alignmentMap = new HashMap();
		try {
		String tmp;
		while ( ( tmp = input.readLine() ) != null )
		{
			StringTokenizer st = new StringTokenizer(tmp,"~");
			String key = st.nextToken();
			String value = st.nextToken();
				
			alignmentMap.put( key, value );
		}

		} catch (Exception  e) 
		{ 
			e.printStackTrace(); 
			System.err.println("ERROR: Failed to read alignment file.");
			System.err.println("       Cannot continue.  Exiting.");
			System.exit(1); 
		}
	}

	public Map getAlignmentMap() { return alignmentMap; }
}      

