
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/alignments/EdgeKey.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.alignments;



import java.lang.*;
import java.util.*;


public class EdgeKey
{
	protected int beginX; 
	protected int beginY;
	protected int endX;
	protected int endY; 
	protected char topChar; 
	protected char botChar;
	private int hashCode;

	public EdgeKey()
	{ 
		beginX = 0;
		beginY = 0;
		endX = 0;
		endY = 0;
		topChar = 'a';
		botChar = 'a';
		hashCode = 0;
	}

	public EdgeKey ( String s )
	{
		int bX = 0;
		int bY = 0;
		int eX = 0;
		int eY = 0;
		char tc = 'a';
		char bc = 'a';

		StringTokenizer st = new StringTokenizer( s, ".");

		tc = st.nextToken().charAt(0);
		bX = Integer.parseInt( st.nextToken() );
		eX = Integer.parseInt( st.nextToken() );
		bc = st.nextToken().charAt(0); 
		bY = Integer.parseInt( st.nextToken() );
		eY = Integer.parseInt( st.nextToken() );
			

		set( bX, bY, eX, eY, tc, bc );
	}


	public EdgeKey( int bX, int bY, int eX, int eY, char tc, char bc )
	{
		set( bX, bY, eX, eY, tc, bc );
	}

	public void set( int bX, int bY, int eX, int eY, char tc, char bc )
	{
		beginX = bX;
		beginY = bY;
		endX = eX;
		endY = eY;
		topChar = tc;
		botChar = bc;

		String s = topChar + Integer.toString(beginX) + 
				   Integer.toString(beginY) + botChar + 
				   Integer.toString(endX) + Integer.toString(endY);
				   
		hashCode = s.hashCode();

	}

	public int getBeginX()
	{ return beginX; }

	public int getBeginY()
	{ return beginY; }

	public int getEndX()
	{ return endX; }

	public int getEndY()
	{ return endY; }

	public char getTopChar()
	{ return topChar; }

	public char getBotChar()
	{ return botChar; }

	public String getTopCharString()
	{ return Character.toString( topChar ); }

	public String getBotCharString()
	{ return Character.toString( botChar ); }

	public boolean equals( Object ek )
	{
		if ( this == ek )
			return true;

		if ( ek instanceof EdgeKey )
		{
			if ( beginX == ((EdgeKey)ek).getBeginX() &&
				 beginY == ((EdgeKey)ek).getBeginY() &&
				 endX == ((EdgeKey)ek).getEndX() &&
				 endY == ((EdgeKey)ek).getEndY() &&
				 hashCode == ((EdgeKey)ek).hashCode() &&
				 topChar == ((EdgeKey)ek).getTopChar() &&
				 botChar == ((EdgeKey)ek).getBotChar() )
				return true;
			else
				return false;
		}
		else
			return false;
	}

	public int hashCode()
	{ return hashCode; }

	public String toString()
	{
		String s = "EdgeKey: " + beginX + " " + beginY + " " + 
		           endX + " " + endY + " " + topChar + " " + 
				   botChar + " " + hashCode;
		return s;
	}

	public Object clone()
	{
		return new EdgeKey( beginX, beginY, endX, endY, topChar, botChar );
	}
}

