
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/conditions/ConditionSelectionPanel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.conditions;



import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.lang.Thread.*;
import java.util.*;
import java.lang.Exception.*;
import java.io.IOException;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.conditions.*;
import edu.virginia.bioch.nopt.conditions.types.*;
import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.*;
import edu.virginia.bioch.nopt.actions.*;

import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;

public class ConditionSelectionPanel extends JPanel
	implements ActionListener, SelectionPanel
{

	protected ConditionTableModel ctm; 
	protected JTable conditionTable; 
	protected ConditionHandler ch; 
	protected MatchConditionCreatorPanel mccp; 

	public ConditionSelectionPanel( ConditionHandler ch, Map conds )
	{
		System.out.println("ConditionSelectionPanel constructor");

		this.ch = ch;

		setBackground(Color.white);
		setLayout( new BoxLayout( this, BoxLayout.Y_AXIS ) );

		mccp = new MatchConditionCreatorPanel();
		mccp.addActionListener( this );
		add( mccp );

		ctm = new ConditionTableModel( );
		conditionTable = new JTable( ctm );
		conditionTable.setBackground( Color.white );
		ctm.addTableModelListener( conditionTable );

		conditionTable.setPreferredScrollableViewportSize(
				                                   new Dimension(800,100));
		JScrollPane tableScroll = new JScrollPane( conditionTable );
		tableScroll.setBorder( 
				BorderFactory.createTitledBorder("Select Filters") );
		tableScroll.setBackground( Color.white );
		tableScroll.getViewport().setBackground( Color.white );

		JPanel table = new JPanel();
		table.setBackground( Color.white );
		table.setLayout(new BorderLayout());
		table.add(conditionTable.getTableHeader(), BorderLayout.NORTH);
		table.add(tableScroll, BorderLayout.CENTER);

		add(table);

	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
	}

	public void actionPerformed(ActionEvent e)
	{
		if ( e.getActionCommand().equals( "add new condition to list" ) )
		{
			try {

			Condition c = mccp.create();

			ch.addCondition( c );
			ctm.addRow( ctm.createRow( c ) );

			mccp.clear();

			System.out.println("ConditionSelectionPanel adding " +c.toString());

			} catch (Exception ex) 
			{
				JOptionPane.showMessageDialog( this, ex.getMessage(), 
						    "Filter Create ERROR", JOptionPane.ERROR_MESSAGE);
			}
		}
	}

	public void prepareSelections()
	{
	}

	public boolean processSelections()
	{
		System.out.println("ConditionSelectionPanel adding selected " + 
				           "conditions to ConditionHandler");

		int rows = ctm.getRowCount();

		for ( int i = 0; i < rows; i ++ )
		{
			Boolean b = (Boolean)ctm.getValueAt(i,(int)0);
			ch.markSelected( i, b.booleanValue() );
		}
		return true;
	}
}
