
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/conditions/ConditionTableModel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.conditions;

import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class ConditionTableModel extends DefaultTableModel 
{
	public ConditionTableModel( )
	{
		super();

		System.out.println("ConditionTableModel constructor");

		columnIdentifiers.add("Display?");
		columnIdentifiers.add("Name");
		columnIdentifiers.add("Type");
		columnIdentifiers.add("Description");

		// no default conditions
	}

	public Vector createRow( Condition c )
	{
		Vector row = new Vector();

		row.add( new Boolean(false) );
		row.add( c.getName() );
		row.add( c.getType() );
		row.add( c.getDescription() );

		return row;
	}

   	public Class getColumnClass(int c) 
	{
		return getValueAt(0, c).getClass();
   	}

   	public boolean isCellEditable(int row, int col) 
	{
		if ( col == 0 ) 
       		return true;
		else 
        	return false;
   	}

   	public void setValueAt(Object value, int row, int col) 
	{
       	System.out.println("ConditionTableModle Setting value at " 
				           + row + "," + col + " to " + value );

		((Vector)dataVector.get(row)).set(col, value);
		fireTableCellUpdated(row, col);
   	}
}
