
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/conditions/types/MatchConditionCreatorPanel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.conditions.types;



import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.lang.Thread.*;
import java.util.*;
import java.lang.Exception.*;
import java.io.IOException;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;

public class MatchConditionCreatorPanel extends JPanel
{
	protected JTextField nameText; 
	protected JTextField beginText;
	protected JTextField endText;
	protected JTextField begin2Text;
	protected JTextField end2Text;
	protected JButton addButton;

	public MatchConditionCreatorPanel( )
	{
		setBackground( Color.white );
		setLayout( new BoxLayout( this, BoxLayout.Y_AXIS ) );
		
		JPanel boxes = new JPanel(); // FlowLayout
		boxes.setBackground( Color.white );

		JLabel nameLabel = new JLabel("Name");
		nameText = new JTextField(40); 
		JPanel namePanel = new JPanel();
		namePanel.add( nameLabel );
		namePanel.add( nameText );
		namePanel.setLayout( new BoxLayout( namePanel, BoxLayout.Y_AXIS ) );
		namePanel.setBackground( Color.white );
		boxes.add( namePanel );


		JLabel spaceLabel = new JLabel("   ");
		boxes.add( spaceLabel );

		JPanel s1Panel = new JPanel();
		JLabel s1Label = new JLabel("Sequence 1");
		s1Panel.setLayout( new BoxLayout( s1Panel, BoxLayout.Y_AXIS ) );
		s1Panel.add( s1Label );
		s1Panel.setBackground( Color.white );

		JPanel s1BeginEndPanel = new JPanel();
		s1BeginEndPanel.setBackground( Color.white );

		JLabel beginLabel = new JLabel("Begin");
		beginText = new JTextField(5); 
		JPanel beginPanel = new JPanel();
		beginPanel.add( beginLabel );
		beginPanel.add( beginText );
		beginPanel.setLayout( new BoxLayout( beginPanel, BoxLayout.Y_AXIS ) );
		beginPanel.setBackground( Color.white );
		s1BeginEndPanel.add( beginPanel );

		JLabel endLabel = new JLabel("End");
		endText = new JTextField(5); 
		JPanel endPanel = new JPanel();
		endPanel.add( endLabel );
		endPanel.add( endText );
		endPanel.setLayout( new BoxLayout( endPanel, BoxLayout.Y_AXIS ) );
		endPanel.setBackground( Color.white );
		s1BeginEndPanel.add( endPanel );

		s1Panel.add( s1BeginEndPanel );

		boxes.add( s1Panel );

		JLabel midLabel = new JLabel("Aligns With");
		boxes.add( midLabel );

		JPanel s2Panel = new JPanel();
		JLabel s2Label = new JLabel("Sequence 2");
		s2Panel.setLayout( new BoxLayout( s2Panel, BoxLayout.Y_AXIS ) );
		s2Panel.add( s2Label );
		s2Panel.setBackground( Color.white );

		JPanel s2BeginEndPanel = new JPanel();
		s2BeginEndPanel.setBackground( Color.white );

		JLabel begin2Label = new JLabel("Begin");
		begin2Text = new JTextField(5); 
		JPanel begin2Panel = new JPanel();
		begin2Panel.add( begin2Label );
		begin2Panel.add( begin2Text );
		begin2Panel.setLayout( new BoxLayout( begin2Panel, BoxLayout.Y_AXIS ) );
		begin2Panel.setBackground( Color.white );
		s2BeginEndPanel.add( begin2Panel );

		JLabel end2Label = new JLabel("End");
		end2Text = new JTextField(5); 
		JPanel end2Panel = new JPanel();
		end2Panel.add( end2Label );
		end2Panel.add( end2Text );
		end2Panel.setLayout( new BoxLayout( end2Panel, BoxLayout.Y_AXIS ) );
		end2Panel.setBackground( Color.white );
		s2BeginEndPanel.add( end2Panel );

		s2Panel.add( s2BeginEndPanel );

		boxes.add( s2Panel );


		add( boxes );

		addButton = new JButton("Add to List");
		addButton.setActionCommand("add new condition to list");
		add( addButton );

		setBorder(BorderFactory.createTitledBorder("Create a Match Filter"));
	}

	public void addActionListener( ActionListener a )
	{
		addButton.addActionListener(a);
	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		setBackground(Color.white);
	}

	private int getNumber( JTextField field ) 
		throws Exception
	{
		int i = 0;
		try {
			i = Integer.parseInt( field.getText() );
		} catch ( NumberFormatException nfe )
		{
			throw new Exception("Invalid number specified in begin/end field"); 
		}

		return i;
	}

	private Range getRange( JTextField beginField, JTextField endField )
		throws Exception
	{
		int begin = getNumber( beginField );
		int end = getNumber( endField );

		while ( begin > end )
		{
			int tmp = begin;
			begin = end;
			end = tmp;

			if ( begin < 0 ) 
				begin = 0;
		}
			
		return new Range( begin, end ); 
	}


	public void clear()
	{
		// clear the boxes
		nameText.setText("");

		beginText.setText("");
		endText.setText("");

		begin2Text.setText("");
		end2Text.setText("");
	}

	public Condition create()
		throws Exception
	{
		String name = nameText.getText();

		if ( name.equals("") )
			throw new Exception("No name specified.");


		Range r1 = getRange(beginText,endText);
		Range r2 = getRange(begin2Text,end2Text);

		String desc = "Only display alignment if seq1 range " + 
		              r1.toSimpleString() + " aligns with seq2 range " + 
					  r2.toSimpleString();

		return new MatchCondition(name, desc, r1, r2);
	}

}
