
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/display/OptionDisplay.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.display;



import java.util.*; 
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.conditions.*;
import edu.virginia.bioch.nopt.actions.*;

import edu.virginia.bioch.util.*;


public class OptionDisplay extends JPanel
	implements Reinitializable
{
	protected Color backgroundColor;
	protected Color conditionColor;
	protected Vector checkList;
	protected Vector itemListeners;
	protected OptionHandler oh;
	protected ConditionHandler ch;
	protected JButton editOptions; 
	protected JButton editConditions; 
	protected JLabel title; 
	protected boolean[] clickList;

	protected OptionSelectionPanel osp;
	protected ConditionSelectionPanel csp;
	protected Component parent;

	public OptionDisplay( OptionHandler OH, 
			              ConditionHandler CH, 
			              OptionSelectionPanel OSP, 
						  ConditionSelectionPanel CSP,
						  Component p)
	{
		System.out.println("OptionDisplay constructor");

		oh = OH;
		ch = CH;
		osp = OSP;
		csp = CSP;
		parent  = p;

		//backgroundColor = new Color(240,240,240);
		backgroundColor = Color.white; 
		conditionColor = new Color(255, 255, 200 );

		editOptions = new JButton( new EditSelectionAction( 
					                  parent, this, osp, "Edit Annotations") );
		editOptions.setToolTipText("Click to edit the available " + 
				                  "annotations in this list.");

		editConditions = new JButton( new EditSelectionAction( 
					                    parent, this, csp, "Edit Filters") );
		editConditions.setToolTipText("Click to edit the available " + 
				                      "filters in this list.");

		title = new JLabel("Display Annotations and Filters");

		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS) );
		//setBorder( BorderFactory.createTitledBorder(
		//			             "Select To Apply") );

		itemListeners = new Vector();

		checkList = new Vector();

		clickList = new boolean[ oh.getNumFixedOptions() ];
		for ( int i = 0; i < clickList.length; i++ )
			clickList[i] = false;

		reinitialize();

	}

	public void reinitialize()
	{
		System.out.println("OptionDisplay reinitialize");

		// first turn everything off
		Iterator it = checkList.iterator();
		int i = 0;
		while ( it.hasNext() )
		{
			JCheckBox j = (JCheckBox)it.next();
			
			// remember what was on
			if ( i < clickList.length )
			{
				if ( j.isSelected() )
					clickList[i] = true;
				else
					clickList[i] = false;	
			}
			
			// then turn it off
			if ( j.isSelected() )
				j.doClick(); 

			i++;
		}

		// first remove everything that exists
		checkList.removeAllElements();
		removeAll();

		// add title
		add( title );

		// add options
		Vector ov = oh.getOptionVector();
		for ( i = 0; i < ov.size(); i++ )
		{
			Option o = (Option)ov.get(i);
			JCheckBox j = new JCheckBox( o.getName(), false );
			j.setToolTipText( o.getDescription() );
			j.setName( o.getName() );
			j.setBackground( backgroundColor );
			j.addItemListener( o );
			checkList.add( j );
			add( j );
		}

		// add conditions
		Vector cv = ch.getSelectedConditions();
		for ( i = 0; i < cv.size(); i++ )
		{
			Condition c = (Condition)cv.get(i);
			JCheckBox j = new JCheckBox( c.getName() + " (" + 
					                     c.getType() + ")", false );
			j.setToolTipText( c.getDescription() );
			j.setName( c.getName() );
			j.setBackground( conditionColor );
			j.addItemListener( c );
			checkList.add( j );
			add( j );
		}

		// add buttons
		add( editOptions );
		add( editConditions );

		// turn everything back on
		for ( i = 0; i < clickList.length; i++ )
			if ( clickList[i] )
				((JCheckBox)(checkList.get(i))).doClick();
		
		// re-add any ItemListeners
		for ( i = 0; i < itemListeners.size(); i++ )
			reallyAddItemListener( (ItemListener)itemListeners.get(i) );
	}

	public void addItemListener( ItemListener l )
	{
		reallyAddItemListener( l );
		itemListeners.add( l );
	}

	private void reallyAddItemListener( ItemListener l )
	{
		for ( int i = 0; i < checkList.size(); i++ )
			((JCheckBox)checkList.get(i)).addItemListener( l );
	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		setBackground(backgroundColor );
	}

}

