
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/display/path/PHorizontalSequence.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.display.path;

import java.awt.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.text.*;
import java.util.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;

public class PHorizontalSequence extends PSpacedSequence 
{

	public PHorizontalSequence( String s, int off, int el, 
			                    int cent, int cw, Font nf )
	{
		super(s,off,el,cent,cw,nf);
		super.setBounds(0, 0, offset + (edgeLen*seq.length()), offset);
		
	}

	public double getX( int i )
	{
		return (double)(offset + (edgeLen * i)-charWidth - center);
	}

	public double getY( int i )
	{
		return (double)(0 - center) ; 
	}

	public int getXNumOffset()
	{
		return 0;
	}

	public int getYNumOffset()
	{
		return 2*edgeLen;
	}
}
