
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/OptionTableModel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options;

import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.regex.*;

import edu.virginia.bioch.nopt.alignments.*;

public class OptionTableModel extends DefaultTableModel 
{
	protected AlignmentHandler ah;
	protected Map allOptions;

	public OptionTableModel( AlignmentHandler ah, Map opts )
	{
		super();

		this.ah = ah;

		allOptions = new HashMap();

		System.out.println("OptionTableModel constructor");

		columnIdentifiers.add("Display?");
		columnIdentifiers.add("Applicable Seq");
		columnIdentifiers.add("Highlight Icon");
		columnIdentifiers.add("Annotation ID");
		columnIdentifiers.add("Range");

		addRows( opts );
	}

	public Map getOptions()
	{ return allOptions; }

	public void addRows( Map opts )
	{
		Iterator it = opts.keySet().iterator();
		while ( it.hasNext() )
		{
			OptionKey key = (OptionKey)(it.next());
			addRow( createRow( key, (String)(opts.get( key )) ) );
		}
	}

	public Vector createRow( OptionKey key, String range )
	{
		allOptions.put( key, range );

		Vector row = new Vector();

		row.add( new Boolean(false) );

		if ( ah.getSeq1Name().equals( key.getSeqName() ) )
			row.add( Option.getSeq1Id() );
		else if ( ah.getSeq2Name().equals( key.getSeqName() ) )
			row.add( Option.getSeq2Id() );
		else
			row.add( getUnselectedSeq() );

		row.add( getUnselectedType() );

		row.add( key.toString() );
		row.add( range );

		return row;
	}

	public String getUnselectedSeq()
	{
		return "<click cell to select seq>";
	}

	public String getUnselectedType()
	{
		return "<click cell to select icon>";
	}

   	public Class getColumnClass(int c) 
	{
            return getValueAt(0, c).getClass();
   	}

   	public boolean isCellEditable(int row, int col) 
	{
		if ( col > 2 ) 
       		return false;
		else 
        	return true;
   	}

   	public void setValueAt(Object value, int row, int col) 
	{
       	System.out.println("OptionTableModel Setting value at " 
				                   + row + "," + col
                                   + " to " + value );

		((Vector)dataVector.get(row)).set(col, value);
		fireTableCellUpdated(row, col);
   	}
}
