
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/styles/ConservedOption.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options.styles;


import java.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import java.lang.*;
import java.net.*;
import java.text.*;
import java.util.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.util.*;


public class ConservedOption extends Option
{
	protected int maxCount;
	protected int power;
	protected Rectangle2D.Double r1; 
	protected Color[] oranges;
	protected Color origColor;
	protected int numColors;

	public static String getTitle() { return "Conserved Option" ; }
	public static ImageIcon getIcon()
	{
		return Option.createIcon("images/ConservedOption.icon.png", 
				                 "Conserved Option"); 
	}

	public ConservedOption( AlignmentHandler ah )
	{
		super("Conserved Highlight","",Option._bothId, 
			  "CONSERVED", ah, "Highlight conserved regions of alignment." );
		System.out.println("ConservedOption constructor");

		maxCount = _ah.getMaxCount(); 

		r1 = new Rectangle2D.Double( -1,
						             -_ascent,
									 _glyphWidth + 2, 
									 _ascent + 
										    _descent + 
										    _separation +
										    _ascent + 
										    _descent  );

		// Keep an array of colors around to avoid creating new Color objects
		// all of the time.
		numColors = 10;
		oranges = new Color[numColors+1];
		oranges[0] = Color.white; 
		for ( int i = 1; i < oranges.length; i++ )
			oranges[i] = new Color( Color.HSBtoRGB((float)0.1,
												   (float)i/(float)numColors,
												   (float)0.95));
		origColor = Color.white;

		// power affects the variation of the saturation. The higher the
		// power the greater the difference between conserved and 
		// unconserved.
		power = 2;
	}

	public void addKey( EdgeKey key )
	{
		// don't add any keys as everything gets colored according to
		// the current count for the key
	}

	public void draw(EdgeKey key, int i, double xPos, double yPos, Graphics2D g,
                     String char1, String char2, int s1Count, int s2Count)
	{
		if ( _on ) 
		{
			// save original state
			origColor = g.getColor();
			//_origTransform = g.getTransform();

			float sat = 1;
			float max = 1;
			for ( int x = 0; x < power; x++ )
			{
				sat *= (float)(_ah.getCount( key ));
				max *= (float)maxCount;
			}
			int satIndex = Math.round( sat*((float)numColors)/max );

			g.setColor( oranges[satIndex] );
			g.fill( r1 );

			g.setColor( origColor );
        }
	}
}


