
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/styles/SimilarityOption.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options.styles;



import java.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import java.lang.*;
import java.net.*;
import java.text.*;
import java.util.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.util.*;
import edu.virginia.bioch.scoringmatrices.*;
import edu.virginia.bioch.nopt.options.*;


public class SimilarityOption extends Option
{
	protected Color origColor;
	protected Rectangle2D.Double r1;
	protected ScoringMatrix sm;

	public static String getTitle() { return "Similarity Option" ; }
	public static ImageIcon getIcon()
	{
		return Option.createIcon("images/SimilarityOption.icon.png", 
				                 "Similarity Option"); 
	}

	public SimilarityOption( AlignmentHandler ah )
	{
		super("Similarity Highlight", "", Option._bothId, "SIMILARITY", ah,
			  "Highlight similar characters.");

		System.out.println("SimilarityOption constructor");

		r1 = new Rectangle2D.Double( 0, 
						            _descent + _separation/2,
									_glyphWidth, 
									_separation/2 );
		sm = null;
	}

	public void addKey( EdgeKey key )
	{
		if ( !_edgesToDraw.containsKey( key ) )
		{
			String char1 = key.getTopCharString();
			String char2 = key.getBotCharString();

			if ( !char1.equals(gap) && !char2.equals(gap) ) 
				_edgesToDraw.put( key, new Boolean( true ) );
			else
				_edgesToDraw.put( key, new Boolean( false ) );
		}
	}


	public void draw(EdgeKey key, int i, double xPos, double yPos, Graphics2D g,
                     String char1, String char2, int s1Count, int s2Count)
	{
		Alignment al = _ah.getCurrentAlignment();
		AlignmentParameters ap = al.getAlignmentParameters();
		sm = ap.getScoringMatrix();

		if ( ((Boolean)_edgesToDraw.get( key )).booleanValue() && _on &&
			 sm.score( key.getTopChar(), key.getBotChar() ) > 0 )
		{
			origColor = g.getColor();

			g.setColor( Color.pink );
			g.fill(r1);

			g.setColor( origColor );
        }
	}
}

