
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/styles/UserOption.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options.styles;



import java.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import java.lang.*;
import java.net.*;
import java.text.*;
import java.util.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;

import edu.virginia.bioch.util.*;



public class UserOption extends Option
{
	protected static int topCount;
	protected static int botCount;

	public static String getTitle() { return "User Option" ; }
	public static ImageIcon getIcon()
	{
		return Option.createIcon("images/UserOption.icon.png", 
				                 "User Option"); 
	}

	static
	{
		// Counts are different because the origin of the hightlight 
		// rectangle is the top right corner, therefore the top needs to
		// be offset initially whereas the bottom doesn't.
		topCount = 1;  
		botCount = 0;
	}

	protected Color purple;
	protected Color origColor;
	protected int topOffset;
	protected int botOffset;
	protected double rectSpace;
	protected double rectHeight;							 
	protected Rectangle2D.Double topRect;
	protected Rectangle2D.Double botRect;

	public UserOption(String n, String rs, String type, AlignmentHandler ah,
			          String d ) 
	{
		super( n, rs, type, "USER", ah, d ); 
		System.out.println("UserOption constructor: " + n + " " + rs + 
						    " " + type);

		if ( _applicableSeq.equals(Option._seq1Id) )
			topOffset = topCount++;
		else if ( _applicableSeq.equals(Option._seq2Id) )
			botOffset = botCount++;
		else if ( _applicableSeq.equals(Option._bothId) ) 
		{
			topOffset = topCount++;
			botOffset = botCount++;
		}

		System.out.println("   offsets top: " + topOffset + 
						   "   bot: " + botOffset);

		rectSpace = 4.0;
		rectHeight = rectSpace *0.75;							 

		topRect = new Rectangle2D.Double( 0,
									  	  0 - 
										  _ascent - 
									      (topOffset*rectSpace) +
									      (rectSpace - rectHeight),
									      _glyphWidth,
									      rectHeight);

		botRect = new Rectangle2D.Double( 0,
										  _descent +
										  _separation +
										  _ascent +
										  _descent+
										  (botOffset*rectSpace),
										  _glyphWidth,
										  rectHeight);

		purple = new Color(0.7f,0,0.7f);

	}

	// use default addRange
	
	public void draw(EdgeKey key, int i, double xPos, double yPos, Graphics2D g,
	                 String c1, String c2, int count1, int count2)
	{
		if ( ((Boolean)_edgesToDraw.get( key )).booleanValue() && _on )	
		{
			origColor = g.getColor();
			g.setColor(purple);

			if (_applicableSeq.equals(Option._seq1Id) || 
				_applicableSeq.equals(Option._bothId) ) 
				g.fill(topRect);
			

			if (_applicableSeq.equals(Option._seq2Id) || 
				_applicableSeq.equals(Option._bothId) ) 
				g.fill(botRect);

			g.setColor(origColor);
		}
	}
}

