
/*
 * 
 *  file:  ./src/edu/virginia/bioch/scoringmatrices/BlosumMatrices.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.scoringmatrices;

//===================================================================
//
// Scoring Matrices delivered with BLAST and Java-ized.
//
//===================================================================


import java.lang.*;

interface BlosumMatrices
{

	//  Matrix made by matblas from blosum100_3.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 100
	//  Entropy =   1.4516, Expected =  -1.0948
	public final String blosum100_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum100_50 =  { 
	 8,
	-3, 10,
	-4,-2, 11,
	-5,-5, 1, 10,
	-2,-8,-5,-8, 14,
	-2, 0,-1,-2,-7, 11,
	-3,-2,-2, 2,-9, 2, 10,
	-1,-6,-2,-4,-7,-5,-6, 9,
	-4,-1, 0,-3,-8, 1,-2,-6, 13,
	-4,-7,-7,-8,-3,-6,-7,-9,-7, 8,
	-4,-6,-7,-8,-5,-5,-7,-8,-6, 2, 8,
	-2, 3,-1,-3,-8, 2, 0,-5,-3,-6,-6, 10,
	-3,-4,-5,-8,-4,-2,-5,-7,-5, 1, 3,-4, 12,
	-5,-6,-7,-8,-4,-6,-8,-8,-4,-2, 0,-6,-1, 11,
	-2,-5,-5,-5,-8,-4,-4,-6,-5,-7,-7,-3,-5,-7, 12,
	 1,-3, 0,-2,-3,-2,-2,-2,-3,-5,-6,-2,-4,-5,-3, 9,
	-1,-3,-1,-4,-3,-3,-3,-5,-4,-3,-4,-3,-2,-5,-4, 2, 9,
	-6,-7,-8,-10,-7,-5,-8,-7,-5,-6,-5,-8,-4, 0,-8,-7,-7, 17,
	-5,-5,-5,-7,-6,-4,-7,-8, 1,-4,-4,-5,-5, 4,-7,-5,-5, 2, 12,
	-2,-6,-7,-8,-3,-5,-5,-8,-7, 4, 0,-5, 0,-3,-6,-4,-1,-5,-5, 8,
	-4,-4, 5, 6,-7,-2, 0,-3,-2,-8,-8,-2,-7,-7,-5,-1,-2,-9,-6,-7, 6,
	-2,-1,-2, 0,-8, 5, 7,-5,-1,-7,-6, 0,-4,-7,-4,-2,-3,-7,-6,-5, 0, 6,
	-2,-3,-3,-4,-5,-2,-3,-4,-4,-3,-3,-3,-3,-4,-4,-2,-2,-6,-4,-3,-4,-2,-3,
	-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
	};


	//  Matrix made by matblas from blosum100_3.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 100
	//  Entropy =   1.4516, Expected =  -1.0948
	public final String blosum100_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum100 =  { 
	 8,
	-3, 10,
	-4,-2, 11,
	-5,-5, 1, 10,
	-2,-8,-5,-8, 14,
	-2, 0,-1,-2,-7, 11,
	-3,-2,-2, 2,-9, 2, 10,
	-1,-6,-2,-4,-7,-5,-6, 9,
	-4,-1, 0,-3,-8, 1,-2,-6, 13,
	-4,-7,-7,-8,-3,-6,-7,-9,-7, 8,
	-4,-6,-7,-8,-5,-5,-7,-8,-6, 2, 8,
	-2, 3,-1,-3,-8, 2, 0,-5,-3,-6,-6, 10,
	-3,-4,-5,-8,-4,-2,-5,-7,-5, 1, 3,-4, 12,
	-5,-6,-7,-8,-4,-6,-8,-8,-4,-2, 0,-6,-1, 11,
	-2,-5,-5,-5,-8,-4,-4,-6,-5,-7,-7,-3,-5,-7, 12,
	 1,-3, 0,-2,-3,-2,-2,-2,-3,-5,-6,-2,-4,-5,-3, 9,
	-1,-3,-1,-4,-3,-3,-3,-5,-4,-3,-4,-3,-2,-5,-4, 2, 9,
	-6,-7,-8,-10,-7,-5,-8,-7,-5,-6,-5,-8,-4, 0,-8,-7,-7, 17,
	-5,-5,-5,-7,-6,-4,-7,-8, 1,-4,-4,-5,-5, 4,-7,-5,-5, 2, 12,
	-2,-6,-7,-8,-3,-5,-5,-8,-7, 4, 0,-5, 0,-3,-6,-4,-1,-5,-5, 8,
	-4,-4, 5, 6,-7,-2, 0,-3,-2,-8,-8,-2,-7,-7,-5,-1,-2,-9,-6,-7, 6,
	-2,-1,-2, 0,-8, 5, 7,-5,-1,-7,-6, 0,-4,-7,-4,-2,-3,-7,-6,-5, 0, 6,
	-2,-3,-3,-4,-5,-2,-3,-4,-4,-3,-3,-3,-3,-4,-4,-2,-2,-6,-4,-3,-4,-2,-3,
	-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
	};


	//  Matrix made by matblas from blosum30.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/5 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 30
	//  Entropy =   0.1424, Expected =  -0.1074
	public final String blosum30_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum30_50 =  { 
	 4,
	-1, 8,
	 0,-2, 8,
	 0,-1, 1, 9,
	-3,-2,-1,-3, 17,
	 1, 3,-1,-1,-2, 8,
	 0,-1,-1, 1, 1, 2, 6,
	 0,-2, 0,-1,-4,-2,-2, 8,
	-2,-1,-1,-2,-5, 0, 0,-3, 14,
	 0,-3, 0,-4,-2,-2,-3,-1,-2, 6,
	-1,-2,-2,-1, 0,-2,-1,-2,-1, 2, 4,
	 0, 1, 0, 0,-3, 0, 2,-1,-2,-2,-2, 4,
	 1, 0, 0,-3,-2,-1,-1,-2, 2, 1, 2, 2, 6,
	-2,-1,-1,-5,-3,-3,-4,-3,-3, 0, 2,-1,-2, 10,
	-1,-1,-3,-1,-3, 0, 1,-1, 1,-3,-3, 1,-4,-4, 11,
	 1,-1, 0, 0,-2,-1, 0, 0,-1,-1,-2, 0,-2,-1,-1, 4,
	 1,-3, 1,-1,-2, 0,-2,-2,-2, 0, 0,-1, 0,-2, 0, 2, 5,
	-5, 0,-7,-4,-2,-1,-1, 1,-5,-3,-2,-2,-3, 1,-3,-3,-5, 20,
	-4, 0,-4,-1,-6,-1,-2,-3, 0,-1, 3,-1,-1, 3,-2,-2,-1, 5, 9,
	 1,-1,-2,-2,-2,-3,-3,-3,-3, 4, 1,-2, 0, 1,-4,-1, 1,-3, 1, 5,
	 0,-2, 4, 5,-2,-1, 0, 0,-2,-2,-1, 0,-2,-3,-2, 0, 0,-5,-3,-2, 5,
	 0, 0,-1, 0, 0, 4, 5,-2, 0,-3,-1, 1,-1,-4, 0,-1,-1,-1,-2,-3, 0, 4,
	 0,-1, 0,-1,-2, 0,-1,-1,-1, 0, 0, 0, 0,-1,-1, 0, 0,-2,-1, 0,-1, 0,-1,
	-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
	};


	//  Matrix made by matblas from blosum30.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/5 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 30
	//  Entropy =   0.1424, Expected =  -0.1074
	public final String blosum30_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum30 =  { 
	 4,
	-1, 8,
	 0,-2, 8,
	 0,-1, 1, 9,
	-3,-2,-1,-3, 17,
	 1, 3,-1,-1,-2, 8,
	 0,-1,-1, 1, 1, 2, 6,
	 0,-2, 0,-1,-4,-2,-2, 8,
	-2,-1,-1,-2,-5, 0, 0,-3, 14,
	 0,-3, 0,-4,-2,-2,-3,-1,-2, 6,
	-1,-2,-2,-1, 0,-2,-1,-2,-1, 2, 4,
	 0, 1, 0, 0,-3, 0, 2,-1,-2,-2,-2, 4,
	 1, 0, 0,-3,-2,-1,-1,-2, 2, 1, 2, 2, 6,
	-2,-1,-1,-5,-3,-3,-4,-3,-3, 0, 2,-1,-2, 10,
	-1,-1,-3,-1,-3, 0, 1,-1, 1,-3,-3, 1,-4,-4, 11,
	 1,-1, 0, 0,-2,-1, 0, 0,-1,-1,-2, 0,-2,-1,-1, 4,
	 1,-3, 1,-1,-2, 0,-2,-2,-2, 0, 0,-1, 0,-2, 0, 2, 5,
	-5, 0,-7,-4,-2,-1,-1, 1,-5,-3,-2,-2,-3, 1,-3,-3,-5, 20,
	-4, 0,-4,-1,-6,-1,-2,-3, 0,-1, 3,-1,-1, 3,-2,-2,-1, 5, 9,
	 1,-1,-2,-2,-2,-3,-3,-3,-3, 4, 1,-2, 0, 1,-4,-1, 1,-3, 1, 5,
	 0,-2, 4, 5,-2,-1, 0, 0,-2,-2,-1, 0,-2,-3,-2, 0, 0,-5,-3,-2, 5,
	 0, 0,-1, 0, 0, 4, 5,-2, 0,-3,-1, 1,-1,-4, 0,-1,-1,-1,-2,-3, 0, 4,
	 0,-1, 0,-1,-2, 0,-1,-1,-1, 0, 0, 0, 0,-1,-1, 0, 0,-2,-1, 0,-1, 0,-1,
	-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
	};


	//  Matrix made by matblas from blosum35.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/4 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 35
	//  Entropy =   0.2111, Expected =  -0.1550
	public final String blosum35_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum35_50 =  { 
	 5,
	-1, 8,
	-1,-1, 7,
	-1,-1, 1, 8,
	-2,-3,-1,-3, 15,
	 0, 2, 1,-1,-3, 7,
	-1,-1,-1, 2,-1, 2, 6,
	 0,-2, 1,-2,-3,-2,-2, 7,
	-2,-1, 1, 0,-4,-1,-1,-2, 12,
	-1,-3,-1,-3,-4,-2,-3,-3,-3, 5,
	-2,-2,-2,-2,-2,-2,-1,-3,-2, 2, 5,
	 0, 2, 0,-1,-2, 0, 1,-1,-2,-2,-2, 5,
	 0, 0,-1,-3,-4,-1,-2,-1, 1, 1, 3, 0, 6,
	-2,-1,-1,-3,-4,-4,-3,-3,-3, 1, 2,-1, 0, 8,
	-2,-2,-2,-1,-4, 0, 0,-2,-1,-1,-3, 0,-3,-4, 10,
	 1,-1, 0,-1,-3, 0, 0, 1,-1,-2,-2, 0,-1,-1,-2, 4,
	 0,-2, 0,-1,-1, 0,-1,-2,-2,-1, 0, 0, 0,-1, 0, 2, 5,
	-2, 0,-2,-3,-5,-1,-1,-1,-4,-1, 0, 0, 1, 1,-4,-2,-2, 16,
	-1, 0,-2,-2,-5, 0,-1,-2, 0, 0, 0,-1, 0, 3,-3,-1,-2, 3, 8,
	 0,-1,-2,-2,-2,-3,-2,-3,-4, 4, 2,-2, 1, 1,-3,-1, 1,-2, 0, 5,
	-1,-1, 4, 5,-2, 0, 0, 0, 0,-2,-2, 0,-2,-2,-1, 0,-1,-3,-2,-2, 5,
	-1, 0, 0, 1,-2, 4, 5,-2,-1,-3,-2, 1,-2,-3, 0, 0,-1,-1,-1,-2, 0, 4,
	 0,-1, 0,-1,-2,-1,-1,-1,-1, 0, 0, 0, 0,-1,-1, 0, 0,-1,-1, 0,-1, 0,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum35.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/4 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 35
	//  Entropy =   0.2111, Expected =  -0.1550
	public final String blosum35_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum35 =  { 
	 5,
	-1, 8,
	-1,-1, 7,
	-1,-1, 1, 8,
	-2,-3,-1,-3, 15,
	 0, 2, 1,-1,-3, 7,
	-1,-1,-1, 2,-1, 2, 6,
	 0,-2, 1,-2,-3,-2,-2, 7,
	-2,-1, 1, 0,-4,-1,-1,-2, 12,
	-1,-3,-1,-3,-4,-2,-3,-3,-3, 5,
	-2,-2,-2,-2,-2,-2,-1,-3,-2, 2, 5,
	 0, 2, 0,-1,-2, 0, 1,-1,-2,-2,-2, 5,
	 0, 0,-1,-3,-4,-1,-2,-1, 1, 1, 3, 0, 6,
	-2,-1,-1,-3,-4,-4,-3,-3,-3, 1, 2,-1, 0, 8,
	-2,-2,-2,-1,-4, 0, 0,-2,-1,-1,-3, 0,-3,-4, 10,
	 1,-1, 0,-1,-3, 0, 0, 1,-1,-2,-2, 0,-1,-1,-2, 4,
	 0,-2, 0,-1,-1, 0,-1,-2,-2,-1, 0, 0, 0,-1, 0, 2, 5,
	-2, 0,-2,-3,-5,-1,-1,-1,-4,-1, 0, 0, 1, 1,-4,-2,-2, 16,
	-1, 0,-2,-2,-5, 0,-1,-2, 0, 0, 0,-1, 0, 3,-3,-1,-2, 3, 8,
	 0,-1,-2,-2,-2,-3,-2,-3,-4, 4, 2,-2, 1, 1,-3,-1, 1,-2, 0, 5,
	-1,-1, 4, 5,-2, 0, 0, 0, 0,-2,-2, 0,-2,-2,-1, 0,-1,-3,-2,-2, 5,
	-1, 0, 0, 1,-2, 4, 5,-2,-1,-3,-2, 1,-2,-3, 0, 0,-1,-1,-1,-2, 0, 4,
	 0,-1, 0,-1,-2,-1,-1,-1,-1, 0, 0, 0, 0,-1,-1, 0, 0,-1,-1, 0,-1, 0,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum40.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/4 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 40
	//  Entropy =   0.2851, Expected =  -0.2090
	public final String blosum40_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum40_50 =  { 
	 5,
	-2, 9,
	-1, 0, 8,
	-1,-1, 2, 9,
	-2,-3,-2,-2, 16,
	 0, 2, 1,-1,-4, 8,
	-1,-1,-1, 2,-2, 2, 7,
	 1,-3, 0,-2,-3,-2,-3, 8,
	-2, 0, 1, 0,-4, 0, 0,-2, 13,
	-1,-3,-2,-4,-4,-3,-4,-4,-3, 6,
	-2,-2,-3,-3,-2,-2,-2,-4,-2, 2, 6,
	-1, 3, 0, 0,-3, 1, 1,-2,-1,-3,-2, 6,
	-1,-1,-2,-3,-3,-1,-2,-2, 1, 1, 3,-1, 7,
	-3,-2,-3,-4,-2,-4,-3,-3,-2, 1, 2,-3, 0, 9,
	-2,-3,-2,-2,-5,-2, 0,-1,-2,-2,-4,-1,-2,-4, 11,
	 1,-1, 1, 0,-1, 1, 0, 0,-1,-2,-3, 0,-2,-2,-1, 5,
	 0,-2, 0,-1,-1,-1,-1,-2,-2,-1,-1, 0,-1,-1, 0, 2, 6,
	-3,-2,-4,-5,-6,-1,-2,-2,-5,-3,-1,-2,-2, 1,-4,-5,-4, 19,
	-2,-1,-2,-3,-4,-1,-2,-3, 2, 0, 0,-1, 1, 4,-3,-2,-1, 3, 9,
	 0,-2,-3,-3,-2,-3,-3,-4,-4, 4, 2,-2, 1, 0,-3,-1, 1,-3,-1, 5,
	-1,-1, 4, 6,-2, 0, 1,-1, 0,-3,-3, 0,-3,-3,-2, 0, 0,-4,-3,-3, 5,
	-1, 0, 0, 1,-3, 4, 5,-2, 0,-4,-2, 1,-2,-4,-1, 0,-1,-2,-2,-3, 2, 5,
	 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1, 0,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
	-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
	};


	//  Matrix made by matblas from blosum40.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/4 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 40
	//  Entropy =   0.2851, Expected =  -0.2090
	public final String blosum40_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum40 =  { 
	 5,
	-2, 9,
	-1, 0, 8,
	-1,-1, 2, 9,
	-2,-3,-2,-2, 16,
	 0, 2, 1,-1,-4, 8,
	-1,-1,-1, 2,-2, 2, 7,
	 1,-3, 0,-2,-3,-2,-3, 8,
	-2, 0, 1, 0,-4, 0, 0,-2, 13,
	-1,-3,-2,-4,-4,-3,-4,-4,-3, 6,
	-2,-2,-3,-3,-2,-2,-2,-4,-2, 2, 6,
	-1, 3, 0, 0,-3, 1, 1,-2,-1,-3,-2, 6,
	-1,-1,-2,-3,-3,-1,-2,-2, 1, 1, 3,-1, 7,
	-3,-2,-3,-4,-2,-4,-3,-3,-2, 1, 2,-3, 0, 9,
	-2,-3,-2,-2,-5,-2, 0,-1,-2,-2,-4,-1,-2,-4, 11,
	 1,-1, 1, 0,-1, 1, 0, 0,-1,-2,-3, 0,-2,-2,-1, 5,
	 0,-2, 0,-1,-1,-1,-1,-2,-2,-1,-1, 0,-1,-1, 0, 2, 6,
	-3,-2,-4,-5,-6,-1,-2,-2,-5,-3,-1,-2,-2, 1,-4,-5,-4, 19,
	-2,-1,-2,-3,-4,-1,-2,-3, 2, 0, 0,-1, 1, 4,-3,-2,-1, 3, 9,
	 0,-2,-3,-3,-2,-3,-3,-4,-4, 4, 2,-2, 1, 0,-3,-1, 1,-3,-1, 5,
	-1,-1, 4, 6,-2, 0, 1,-1, 0,-3,-3, 0,-3,-3,-2, 0, 0,-4,-3,-3, 5,
	-1, 0, 0, 1,-3, 4, 5,-2, 0,-4,-2, 1,-2,-4,-1, 0,-1,-2,-2,-3, 2, 5,
	 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1, 0,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
	-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
	};


	//  Matrix made by matblas from blosum45.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 45
	//  Entropy =   0.3795, Expected =  -0.2789
	public final String blosum45_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum45_50 =  { 
	 5,
	-2, 7,
	-1, 0, 6,
	-2,-1, 2, 7,
	-1,-3,-2,-3, 12,
	-1, 1, 0, 0,-3, 6,
	-1, 0, 0, 2,-3, 2, 6,
	 0,-2, 0,-1,-3,-2,-2, 7,
	-2, 0, 1, 0,-3, 1, 0,-2, 10,
	-1,-3,-2,-4,-3,-2,-3,-4,-3, 5,
	-1,-2,-3,-3,-2,-2,-2,-3,-2, 2, 5,
	-1, 3, 0, 0,-3, 1, 1,-2,-1,-3,-3, 5,
	-1,-1,-2,-3,-2, 0,-2,-2, 0, 2, 2,-1, 6,
	-2,-2,-2,-4,-2,-4,-3,-3,-2, 0, 1,-3, 0, 8,
	-1,-2,-2,-1,-4,-1, 0,-2,-2,-2,-3,-1,-2,-3, 9,
	 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-3,-1,-2,-2,-1, 4,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-1,-1, 2, 5,
	-2,-2,-4,-4,-5,-2,-3,-2,-3,-2,-2,-2,-2, 1,-3,-4,-3, 15,
	-2,-1,-2,-2,-3,-1,-2,-3, 2, 0, 0,-1, 0, 3,-3,-2,-1, 3, 8,
	 0,-2,-3,-3,-1,-3,-3,-3,-3, 3, 1,-2, 1, 0,-3,-1, 0,-3,-1, 5,
	-1,-1, 4, 5,-2, 0, 1,-1, 0,-3,-3, 0,-2,-3,-2, 0, 0,-4,-2,-3, 4,
	-1, 0, 0, 1,-3, 4, 4,-2, 0,-3,-2, 1,-1,-3,-1, 0,-1,-2,-2,-3, 2, 4,
	 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 0, 0,-2,-1,-1,-1,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum45.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 45
	//  Entropy =   0.3795, Expected =  -0.2789
	public final String blosum45_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum45 =  { 
	 5,
	-2, 7,
	-1, 0, 6,
	-2,-1, 2, 7,
	-1,-3,-2,-3, 12,
	-1, 1, 0, 0,-3, 6,
	-1, 0, 0, 2,-3, 2, 6,
	 0,-2, 0,-1,-3,-2,-2, 7,
	-2, 0, 1, 0,-3, 1, 0,-2, 10,
	-1,-3,-2,-4,-3,-2,-3,-4,-3, 5,
	-1,-2,-3,-3,-2,-2,-2,-3,-2, 2, 5,
	-1, 3, 0, 0,-3, 1, 1,-2,-1,-3,-3, 5,
	-1,-1,-2,-3,-2, 0,-2,-2, 0, 2, 2,-1, 6,
	-2,-2,-2,-4,-2,-4,-3,-3,-2, 0, 1,-3, 0, 8,
	-1,-2,-2,-1,-4,-1, 0,-2,-2,-2,-3,-1,-2,-3, 9,
	 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-3,-1,-2,-2,-1, 4,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-1,-1, 2, 5,
	-2,-2,-4,-4,-5,-2,-3,-2,-3,-2,-2,-2,-2, 1,-3,-4,-3, 15,
	-2,-1,-2,-2,-3,-1,-2,-3, 2, 0, 0,-1, 0, 3,-3,-2,-1, 3, 8,
	 0,-2,-3,-3,-1,-3,-3,-3,-3, 3, 1,-2, 1, 0,-3,-1, 0,-3,-1, 5,
	-1,-1, 4, 5,-2, 0, 1,-1, 0,-3,-3, 0,-2,-3,-2, 0, 0,-4,-2,-3, 4,
	-1, 0, 0, 1,-3, 4, 4,-2, 0,-3,-2, 1,-1,-3,-1, 0,-1,-2,-2,-3, 2, 4,
	 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 0, 0,-2,-1,-1,-1,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum50.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 50
	//  Entropy =   0.4808, Expected =  -0.3573
	public final String blosum50_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum50_50 =  { 
	 5,
	-2, 7,
	-1,-1, 7,
	-2,-2, 2, 8,
	-1,-4,-2,-4, 13,
	-1, 1, 0, 0,-3, 7,
	-1, 0, 0, 2,-3, 2, 6,
	 0,-3, 0,-1,-3,-2,-3, 8,
	-2, 0, 1,-1,-3, 1, 0,-2, 10,
	-1,-4,-3,-4,-2,-3,-4,-4,-4, 5,
	-2,-3,-4,-4,-2,-2,-3,-4,-3, 2, 5,
	-1, 3, 0,-1,-3, 2, 1,-2, 0,-3,-3, 6,
	-1,-2,-2,-4,-2, 0,-2,-3,-1, 2, 3,-2, 7,
	-3,-3,-4,-5,-2,-4,-3,-4,-1, 0, 1,-4, 0, 8,
	-1,-3,-2,-1,-4,-1,-1,-2,-2,-3,-4,-1,-3,-4, 10,
	 1,-1, 1, 0,-1, 0,-1, 0,-1,-3,-3, 0,-2,-3,-1, 5,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 2, 5,
	-3,-3,-4,-5,-5,-1,-3,-3,-3,-3,-2,-3,-1, 1,-4,-4,-3, 15,
	-2,-1,-2,-3,-3,-1,-2,-3, 2,-1,-1,-2, 0, 4,-3,-2,-2, 2, 8,
	 0,-3,-3,-4,-1,-3,-3,-4,-4, 4, 1,-3, 1,-1,-3,-2, 0,-3,-1, 5,
	-2,-1, 4, 5,-3, 0, 1,-1, 0,-4,-4, 0,-3,-4,-2, 0, 0,-5,-3,-4, 5,
	-1, 0, 0, 1,-3, 4, 5,-2, 0,-3,-3, 1,-1,-4,-1, 0,-1,-2,-2,-3, 2, 5,
	-1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1, 0,-3,-1,-1,-1,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum50.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 50
	//  Entropy =   0.4808, Expected =  -0.3573
	public final String blosum50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum50 =  { 
	 5,
	-2, 7,
	-1,-1, 7,
	-2,-2, 2, 8,
	-1,-4,-2,-4, 13,
	-1, 1, 0, 0,-3, 7,
	-1, 0, 0, 2,-3, 2, 6,
	 0,-3, 0,-1,-3,-2,-3, 8,
	-2, 0, 1,-1,-3, 1, 0,-2, 10,
	-1,-4,-3,-4,-2,-3,-4,-4,-4, 5,
	-2,-3,-4,-4,-2,-2,-3,-4,-3, 2, 5,
	-1, 3, 0,-1,-3, 2, 1,-2, 0,-3,-3, 6,
	-1,-2,-2,-4,-2, 0,-2,-3,-1, 2, 3,-2, 7,
	-3,-3,-4,-5,-2,-4,-3,-4,-1, 0, 1,-4, 0, 8,
	-1,-3,-2,-1,-4,-1,-1,-2,-2,-3,-4,-1,-3,-4, 10,
	 1,-1, 1, 0,-1, 0,-1, 0,-1,-3,-3, 0,-2,-3,-1, 5,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 2, 5,
	-3,-3,-4,-5,-5,-1,-3,-3,-3,-3,-2,-3,-1, 1,-4,-4,-3, 15,
	-2,-1,-2,-3,-3,-1,-2,-3, 2,-1,-1,-2, 0, 4,-3,-2,-2, 2, 8,
	 0,-3,-3,-4,-1,-3,-3,-4,-4, 4, 1,-3, 1,-1,-3,-2, 0,-3,-1, 5,
	-2,-1, 4, 5,-3, 0, 1,-1, 0,-4,-4, 0,-3,-4,-2, 0, 0,-5,-3,-4, 5,
	-1, 0, 0, 1,-3, 4, 5,-2, 0,-3,-3, 1,-1,-4,-1, 0,-1,-2,-2,-3, 2, 5,
	-1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1, 0,-3,-1,-1,-1,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum55.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 55
	//  Entropy =   0.5637, Expected =  -0.4179
	public final String blosum55_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum55_50 =  { 
	 5,
	-2, 8,
	-2,-1, 8,
	-2,-2, 2, 8,
	 0,-4,-3,-4, 13,
	-1, 1, 0, 0,-4, 7,
	-1, 0, 0, 2,-4, 2, 7,
	 0,-3, 0,-2,-3,-2,-3, 8,
	-2, 0, 1,-1,-4, 1,-1,-2, 11,
	-2,-4,-4,-4,-2,-4,-4,-5,-4, 6,
	-2,-3,-4,-5,-2,-3,-4,-5,-3, 2, 6,
	-1, 3, 0,-1,-4, 2, 1,-2, 0,-4,-3, 6,
	-1,-2,-3,-4,-2, 0,-3,-3,-2, 2, 3,-2, 8,
	-3,-3,-4,-5,-3,-4,-4,-4,-1, 0, 1,-4, 0, 9,
	-1,-3,-2,-2,-3,-1,-1,-3,-3,-3,-4,-1,-3,-5, 10,
	 2,-1, 1, 0,-1, 0, 0, 0,-1,-3,-3, 0,-2,-3,-1, 5,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-3,-1, 2, 6,
	-4,-3,-5,-5,-4,-2,-3,-3,-3,-3,-3,-4,-2, 2,-5,-4,-3, 15,
	-2,-2,-2,-3,-3,-1,-2,-4, 2,-1,-1,-2,-1, 4,-4,-2,-2, 3, 9,
	 0,-3,-4,-4,-1,-3,-3,-4,-4, 4, 1,-3, 1,-1,-3,-2, 0,-4,-2, 5,
	-2,-1, 4, 5,-4, 0, 1,-1, 0,-4,-4, 0,-3,-5,-2, 0,-1,-5,-3,-4, 5,
	-1, 0, 0, 1,-4, 4, 5,-3, 0,-4,-3, 1,-2,-4,-1, 0,-1,-3,-2,-3, 2, 5,
	-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-3,-1,-1,-1,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum55.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 55
	//  Entropy =   0.5637, Expected =  -0.4179
	public final String blosum55_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum55 =  { 
	 5,
	-2, 8,
	-2,-1, 8,
	-2,-2, 2, 8,
	 0,-4,-3,-4, 13,
	-1, 1, 0, 0,-4, 7,
	-1, 0, 0, 2,-4, 2, 7,
	 0,-3, 0,-2,-3,-2,-3, 8,
	-2, 0, 1,-1,-4, 1,-1,-2, 11,
	-2,-4,-4,-4,-2,-4,-4,-5,-4, 6,
	-2,-3,-4,-5,-2,-3,-4,-5,-3, 2, 6,
	-1, 3, 0,-1,-4, 2, 1,-2, 0,-4,-3, 6,
	-1,-2,-3,-4,-2, 0,-3,-3,-2, 2, 3,-2, 8,
	-3,-3,-4,-5,-3,-4,-4,-4,-1, 0, 1,-4, 0, 9,
	-1,-3,-2,-2,-3,-1,-1,-3,-3,-3,-4,-1,-3,-5, 10,
	 2,-1, 1, 0,-1, 0, 0, 0,-1,-3,-3, 0,-2,-3,-1, 5,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-3,-1, 2, 6,
	-4,-3,-5,-5,-4,-2,-3,-3,-3,-3,-3,-4,-2, 2,-5,-4,-3, 15,
	-2,-2,-2,-3,-3,-1,-2,-4, 2,-1,-1,-2,-1, 4,-4,-2,-2, 3, 9,
	 0,-3,-4,-4,-1,-3,-3,-4,-4, 4, 1,-3, 1,-1,-3,-2, 0,-4,-2, 5,
	-2,-1, 4, 5,-4, 0, 1,-1, 0,-4,-4, 0,-3,-5,-2, 0,-1,-5,-3,-4, 5,
	-1, 0, 0, 1,-4, 4, 5,-3, 0,-4,-3, 1,-2,-4,-1, 0,-1,-3,-2,-3, 2, 5,
	-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-3,-1,-1,-1,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum60.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 60
	//  Entropy =   0.6603, Expected =  -0.4917
	public final String blosum60_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum60_50 =  { 
	 4,
	-1, 5,
	-1, 0, 6,
	-2,-1, 1, 6,
	 0,-3,-2,-3, 9,
	-1, 1, 0, 0,-3, 5,
	-1, 0, 0, 2,-3, 2, 5,
	 0,-2, 0,-1,-2,-2,-2, 6,
	-2, 0, 1,-1,-3, 1, 0,-2, 7,
	-1,-3,-3,-3,-1,-3,-3,-3,-3, 4,
	-1,-2,-3,-3,-1,-2,-3,-4,-3, 2, 4,
	-1, 2, 0,-1,-3, 1, 1,-1,-1,-3,-2, 4,
	-1,-1,-2,-3,-1, 0,-2,-2,-1, 1, 2,-1, 5,
	-2,-3,-3,-3,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
	-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4, 7,
	 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-2, 0,-1,-2,-1, 4,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 4,
	-3,-3,-4,-4,-2,-2,-3,-2,-2,-2,-2,-3,-1, 1,-4,-3,-2, 10,
	-2,-2,-2,-3,-2,-1,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 6,
	 0,-2,-3,-3,-1,-2,-2,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
	-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-3, 0,-3,-3,-2, 0, 0,-4,-2,-3, 4,
	-1, 0, 0, 1,-3, 3, 4,-2, 0,-3,-2, 1,-1,-3,-1, 0,-1,-2,-2,-2, 1, 3,
	 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
	-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4, 1
	};


	//  Matrix made by matblas from blosum60.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 60
	//  Entropy =   0.6603, Expected =  -0.4917
	public final String blosum60_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum60 =  { 
	 4,
	-1, 5,
	-1, 0, 6,
	-2,-1, 1, 6,
	 0,-3,-2,-3, 9,
	-1, 1, 0, 0,-3, 5,
	-1, 0, 0, 2,-3, 2, 5,
	 0,-2, 0,-1,-2,-2,-2, 6,
	-2, 0, 1,-1,-3, 1, 0,-2, 7,
	-1,-3,-3,-3,-1,-3,-3,-3,-3, 4,
	-1,-2,-3,-3,-1,-2,-3,-4,-3, 2, 4,
	-1, 2, 0,-1,-3, 1, 1,-1,-1,-3,-2, 4,
	-1,-1,-2,-3,-1, 0,-2,-2,-1, 1, 2,-1, 5,
	-2,-3,-3,-3,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
	-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4, 7,
	 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-2, 0,-1,-2,-1, 4,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 4,
	-3,-3,-4,-4,-2,-2,-3,-2,-2,-2,-2,-3,-1, 1,-4,-3,-2, 10,
	-2,-2,-2,-3,-2,-1,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 6,
	 0,-2,-3,-3,-1,-2,-2,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
	-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-3, 0,-3,-3,-2, 0, 0,-4,-2,-3, 4,
	-1, 0, 0, 1,-3, 3, 4,-2, 0,-3,-2, 1,-1,-3,-1, 0,-1,-2,-2,-2, 1, 3,
	 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
	-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4, 1
	};


	//  Matrix made by matblas from blosum62.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 62
	//  Entropy =   0.6979, Expected =  -0.5209
	public final String blosum62_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum62_50 =  { 
	 4,
	-1, 5,
	-2, 0, 6,
	-2,-2, 1, 6,
	 0,-3,-3,-3, 9,
	-1, 1, 0, 0,-3, 5,
	-1, 0, 0, 2,-4, 2, 5,
	 0,-2, 0,-1,-3,-2,-2, 6,
	-2, 0, 1,-1,-3, 0, 0,-2, 8,
	-1,-3,-3,-3,-1,-3,-3,-4,-3, 4,
	-1,-2,-3,-4,-1,-2,-3,-4,-3, 2, 4,
	-1, 2, 0,-1,-3, 1, 1,-2,-1,-3,-2, 5,
	-1,-1,-2,-3,-1, 0,-2,-3,-2, 1, 2,-1, 5,
	-2,-3,-3,-3,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
	-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4, 7,
	 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-2, 0,-1,-2,-1, 4,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 5,
	-3,-3,-4,-4,-2,-2,-3,-2,-2,-3,-2,-3,-1, 1,-4,-3,-2, 11,
	-2,-2,-2,-3,-2,-1,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
	 0,-3,-3,-3,-1,-2,-2,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
	-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-4, 0,-3,-3,-2, 0,-1,-4,-3,-3, 4,
	-1, 0, 0, 1,-3, 3, 4,-2, 0,-3,-3, 1,-1,-3,-1, 0,-1,-3,-2,-2, 1, 4,
	 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
	-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4, 1
	};


	//  Matrix made by matblas from blosum62.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 62
	//  Entropy =   0.6979, Expected =  -0.5209
	public final String blosum62_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum62 =  { 
	 4,
	-1, 5,
	-2, 0, 6,
	-2,-2, 1, 6,
	 0,-3,-3,-3, 9,
	-1, 1, 0, 0,-3, 5,
	-1, 0, 0, 2,-4, 2, 5,
	 0,-2, 0,-1,-3,-2,-2, 6,
	-2, 0, 1,-1,-3, 0, 0,-2, 8,
	-1,-3,-3,-3,-1,-3,-3,-4,-3, 4,
	-1,-2,-3,-4,-1,-2,-3,-4,-3, 2, 4,
	-1, 2, 0,-1,-3, 1, 1,-2,-1,-3,-2, 5,
	-1,-1,-2,-3,-1, 0,-2,-3,-2, 1, 2,-1, 5,
	-2,-3,-3,-3,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
	-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4, 7,
	 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-2, 0,-1,-2,-1, 4,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 5,
	-3,-3,-4,-4,-2,-2,-3,-2,-2,-3,-2,-3,-1, 1,-4,-3,-2, 11,
	-2,-2,-2,-3,-2,-1,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
	 0,-3,-3,-3,-1,-2,-2,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
	-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-4, 0,-3,-3,-2, 0,-1,-4,-3,-3, 4,
	-1, 0, 0, 1,-3, 3, 4,-2, 0,-3,-3, 1,-1,-3,-1, 0,-1,-3,-2,-2, 1, 4,
	 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
	-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4, 1
	};


	//  Matrix made by matblas from blosum65.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 65
	//  Entropy =   0.7576, Expected =  -0.5675
	public final String blosum65_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum65_50 =  { 
	 4,
	-1, 6,
	-2, 0, 6,
	-2,-2, 1, 6,
	 0,-4,-3,-4, 9,
	-1, 1, 0, 0,-3, 6,
	-1, 0, 0, 2,-4, 2, 5,
	 0,-2,-1,-1,-3,-2,-2, 6,
	-2, 0, 1,-1,-3, 1, 0,-2, 8,
	-1,-3,-3,-3,-1,-3,-3,-4,-3, 4,
	-2,-2,-4,-4,-1,-2,-3,-4,-3, 2, 4,
	-1, 2, 0,-1,-3, 1, 1,-2,-1,-3,-3, 5,
	-1,-2,-2,-3,-2, 0,-2,-3,-2, 1, 2,-2, 6,
	-2,-3,-3,-4,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
	-1,-2,-2,-2,-3,-1,-1,-2,-2,-3,-3,-1,-3,-4, 8,
	 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-3, 0,-2,-2,-1, 4,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 5,
	-3,-3,-4,-5,-2,-2,-3,-3,-2,-2,-2,-3,-2, 1,-4,-3,-3, 10,
	-2,-2,-2,-3,-2,-2,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
	 0,-3,-3,-3,-1,-2,-3,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
	-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-4, 0,-3,-3,-2, 0,-1,-4,-3,-3, 4,
	-1, 0, 0, 1,-4, 3, 4,-2, 0,-3,-3, 1,-2,-3,-1, 0,-1,-3,-2,-2, 1, 4,
	-1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum65.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 65
	//  Entropy =   0.7576, Expected =  -0.5675
	public final String blosum65_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum65 =  { 
	 4,
	-1, 6,
	-2, 0, 6,
	-2,-2, 1, 6,
	 0,-4,-3,-4, 9,
	-1, 1, 0, 0,-3, 6,
	-1, 0, 0, 2,-4, 2, 5,
	 0,-2,-1,-1,-3,-2,-2, 6,
	-2, 0, 1,-1,-3, 1, 0,-2, 8,
	-1,-3,-3,-3,-1,-3,-3,-4,-3, 4,
	-2,-2,-4,-4,-1,-2,-3,-4,-3, 2, 4,
	-1, 2, 0,-1,-3, 1, 1,-2,-1,-3,-3, 5,
	-1,-2,-2,-3,-2, 0,-2,-3,-2, 1, 2,-2, 6,
	-2,-3,-3,-4,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
	-1,-2,-2,-2,-3,-1,-1,-2,-2,-3,-3,-1,-3,-4, 8,
	 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-3, 0,-2,-2,-1, 4,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 5,
	-3,-3,-4,-5,-2,-2,-3,-3,-2,-2,-2,-3,-2, 1,-4,-3,-3, 10,
	-2,-2,-2,-3,-2,-2,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
	 0,-3,-3,-3,-1,-2,-3,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
	-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-4, 0,-3,-3,-2, 0,-1,-4,-3,-3, 4,
	-1, 0, 0, 1,-4, 3, 4,-2, 0,-3,-3, 1,-2,-3,-1, 0,-1,-3,-2,-2, 1, 4,
	-1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum70.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 70
	//  Entropy =   0.8391, Expected =  -0.6313
	public final String blosum70_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum70_50 =  { 
	 4,
	-2, 6,
	-2,-1, 6,
	-2,-2, 1, 6,
	-1,-4,-3,-4, 9,
	-1, 1, 0,-1,-3, 6,
	-1, 0, 0, 1,-4, 2, 5,
	 0,-3,-1,-2,-3,-2,-2, 6,
	-2, 0, 0,-1,-4, 1, 0,-2, 8,
	-2,-3,-4,-4,-1,-3,-4,-4,-4, 4,
	-2,-3,-4,-4,-2,-2,-3,-4,-3, 2, 4,
	-1, 2, 0,-1,-4, 1, 1,-2,-1,-3,-3, 5,
	-1,-2,-2,-3,-2, 0,-2,-3,-2, 1, 2,-2, 6,
	-2,-3,-3,-4,-2,-3,-4,-4,-1, 0, 0,-3, 0, 6,
	-1,-2,-2,-2,-3,-2,-1,-3,-2,-3,-3,-1,-3,-4, 8,
	 1,-1, 0, 0,-1, 0, 0,-1,-1,-3,-3, 0,-2,-3,-1, 4,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-2,-1, 1, 5,
	-3,-3,-4,-5,-3,-2,-4,-3,-2,-3,-2,-3,-2, 1,-4,-3,-3, 11,
	-2,-2,-2,-4,-3,-2,-3,-4, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
	 0,-3,-3,-4,-1,-2,-3,-4,-3, 3, 1,-3, 1,-1,-3,-2, 0,-3,-2, 4,
	-2,-1, 3, 4,-4, 0, 1,-1,-1,-4,-4,-1,-3,-4,-2, 0,-1,-4,-3,-3, 4,
	-1, 0, 0, 1,-4, 3, 4,-2, 0,-3,-3, 1,-2,-4,-1, 0,-1,-3,-2,-3, 0, 4,
	-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-3,-2,-1,-1,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum70.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 70
	//  Entropy =   0.8391, Expected =  -0.6313
	public final String blosum70_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum70 =  { 
	 4,
	-2, 6,
	-2,-1, 6,
	-2,-2, 1, 6,
	-1,-4,-3,-4, 9,
	-1, 1, 0,-1,-3, 6,
	-1, 0, 0, 1,-4, 2, 5,
	 0,-3,-1,-2,-3,-2,-2, 6,
	-2, 0, 0,-1,-4, 1, 0,-2, 8,
	-2,-3,-4,-4,-1,-3,-4,-4,-4, 4,
	-2,-3,-4,-4,-2,-2,-3,-4,-3, 2, 4,
	-1, 2, 0,-1,-4, 1, 1,-2,-1,-3,-3, 5,
	-1,-2,-2,-3,-2, 0,-2,-3,-2, 1, 2,-2, 6,
	-2,-3,-3,-4,-2,-3,-4,-4,-1, 0, 0,-3, 0, 6,
	-1,-2,-2,-2,-3,-2,-1,-3,-2,-3,-3,-1,-3,-4, 8,
	 1,-1, 0, 0,-1, 0, 0,-1,-1,-3,-3, 0,-2,-3,-1, 4,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-2,-1, 1, 5,
	-3,-3,-4,-5,-3,-2,-4,-3,-2,-3,-2,-3,-2, 1,-4,-3,-3, 11,
	-2,-2,-2,-4,-3,-2,-3,-4, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
	 0,-3,-3,-4,-1,-2,-3,-4,-3, 3, 1,-3, 1,-1,-3,-2, 0,-3,-2, 4,
	-2,-1, 3, 4,-4, 0, 1,-1,-1,-4,-4,-1,-3,-4,-2, 0,-1,-4,-3,-3, 4,
	-1, 0, 0, 1,-4, 3, 4,-2, 0,-3,-3, 1,-2,-4,-1, 0,-1,-3,-2,-3, 0, 4,
	-1,-1,-1,-2,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1,-1,-3,-2,-1,-1,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum75.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 75
	//  Entropy =   0.9077, Expected =  -0.6845
	public final String blosum75_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum75_50 =  { 
	 4,
	-2, 6,
	-2,-1, 6,
	-2,-2, 1, 6,
	-1,-4,-3,-4, 9,
	-1, 1, 0,-1,-3, 6,
	-1, 0,-1, 1,-5, 2, 5,
	 0,-3,-1,-2,-3,-2,-3, 6,
	-2, 0, 0,-1,-4, 1, 0,-2, 8,
	-2,-3,-4,-4,-1,-3,-4,-5,-4, 4,
	-2,-3,-4,-4,-2,-3,-4,-4,-3, 1, 4,
	-1, 2, 0,-1,-4, 1, 1,-2,-1,-3,-3, 5,
	-1,-2,-3,-4,-2, 0,-2,-3,-2, 1, 2,-2, 6,
	-3,-3,-4,-4,-2,-4,-4,-4,-2, 0, 0,-4, 0, 6,
	-1,-2,-3,-2,-4,-2,-1,-3,-2,-3,-3,-1,-3,-4, 8,
	 1,-1, 0,-1,-1, 0, 0,-1,-1,-3,-3, 0,-2,-3,-1, 5,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-2,-1, 1, 5,
	-3,-3,-4,-5,-3,-2,-4,-3,-2,-3,-2,-4,-2, 1,-5,-3,-3, 11,
	-2,-2,-3,-4,-3,-2,-3,-4, 2,-2,-1,-2,-2, 3,-4,-2,-2, 2, 7,
	 0,-3,-3,-4,-1,-2,-3,-4,-4, 3, 1,-3, 1,-1,-3,-2, 0,-3,-2, 4,
	-2,-1, 3, 4,-4, 0, 1,-1,-1,-4,-4,-1,-3,-4,-2, 0,-1,-5,-3,-4, 4,
	-1, 0, 0, 1,-4, 3, 4,-2, 0,-4,-3, 1,-2,-4,-2, 0,-1,-3,-3,-3, 0, 4,
	-1,-1,-1,-2,-2,-1,-1,-2,-1,-2,-1,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum75.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 75
	//  Entropy =   0.9077, Expected =  -0.6845
	public final String blosum75_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum75 =  { 
	 4,
	-2, 6,
	-2,-1, 6,
	-2,-2, 1, 6,
	-1,-4,-3,-4, 9,
	-1, 1, 0,-1,-3, 6,
	-1, 0,-1, 1,-5, 2, 5,
	 0,-3,-1,-2,-3,-2,-3, 6,
	-2, 0, 0,-1,-4, 1, 0,-2, 8,
	-2,-3,-4,-4,-1,-3,-4,-5,-4, 4,
	-2,-3,-4,-4,-2,-3,-4,-4,-3, 1, 4,
	-1, 2, 0,-1,-4, 1, 1,-2,-1,-3,-3, 5,
	-1,-2,-3,-4,-2, 0,-2,-3,-2, 1, 2,-2, 6,
	-3,-3,-4,-4,-2,-4,-4,-4,-2, 0, 0,-4, 0, 6,
	-1,-2,-3,-2,-4,-2,-1,-3,-2,-3,-3,-1,-3,-4, 8,
	 1,-1, 0,-1,-1, 0, 0,-1,-1,-3,-3, 0,-2,-3,-1, 5,
	 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-2,-1, 1, 5,
	-3,-3,-4,-5,-3,-2,-4,-3,-2,-3,-2,-4,-2, 1,-5,-3,-3, 11,
	-2,-2,-3,-4,-3,-2,-3,-4, 2,-2,-1,-2,-2, 3,-4,-2,-2, 2, 7,
	 0,-3,-3,-4,-1,-2,-3,-4,-4, 3, 1,-3, 1,-1,-3,-2, 0,-3,-2, 4,
	-2,-1, 3, 4,-4, 0, 1,-1,-1,-4,-4,-1,-3,-4,-2, 0,-1,-5,-3,-4, 4,
	-1, 0, 0, 1,-4, 3, 4,-2, 0,-4,-3, 1,-2,-4,-2, 0,-1,-3,-3,-3, 0, 4,
	-1,-1,-1,-2,-2,-1,-1,-2,-1,-2,-1,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1,
	-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5, 1
	};


	//  Matrix made by matblas from blosum80_3.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 80
	//  Entropy =   0.9868, Expected =  -0.7442
	public final String blosum80_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum80_50 =  { 
	 7,
	-3, 9,
	-3,-1, 9,
	-3,-3, 2, 10,
	-1,-6,-5,-7, 13,
	-2, 1, 0,-1,-5, 9,
	-2,-1,-1, 2,-7, 3, 8,
	 0,-4,-1,-3,-6,-4,-4, 9,
	-3, 0, 1,-2,-7, 1, 0,-4, 12,
	-3,-5,-6,-7,-2,-5,-6,-7,-6, 7,
	-3,-4,-6,-7,-3,-4,-6,-7,-5, 2, 6,
	-1, 3, 0,-2,-6, 2, 1,-3,-1,-5,-4, 8,
	-2,-3,-4,-6,-3,-1,-4,-5,-4, 2, 3,-3, 9,
	-4,-5,-6,-6,-4,-5,-6,-6,-2,-1, 0,-5, 0, 10,
	-1,-3,-4,-3,-6,-3,-2,-5,-4,-5,-5,-2,-4,-6, 12,
	 2,-2, 1,-1,-2,-1,-1,-1,-2,-4,-4,-1,-3,-4,-2, 7,
	 0,-2, 0,-2,-2,-1,-2,-3,-3,-2,-3,-1,-1,-4,-3, 2, 8,
	-5,-5,-7,-8,-5,-4,-6,-6,-4,-5,-4,-6,-3, 0,-7,-6,-5, 16,
	-4,-4,-4,-6,-5,-3,-5,-6, 3,-3,-2,-4,-3, 4,-6,-3,-3, 3, 11,
	-1,-4,-5,-6,-2,-4,-4,-6,-5, 4, 1,-4, 1,-2,-4,-3, 0,-5,-3, 7,
	-3,-2, 5, 6,-6,-1, 1,-2,-1,-6,-7,-1,-5,-6,-4, 0,-1,-8,-5,-6, 6,
	-2, 0,-1, 1,-7, 5, 6,-4, 0,-6,-5, 1,-3,-6,-2,-1,-2,-5,-4,-4, 0, 6,
	-1,-2,-2,-3,-4,-2,-2,-3,-2,-2,-2,-2,-2,-3,-3,-1,-1,-5,-3,-2,-3,-1,-2,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//  Matrix made by matblas from blosum80_3.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 80
	//  Entropy =   0.9868, Expected =  -0.7442
	public final String blosum80_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum80 =  { 
	 7,
	-3, 9,
	-3,-1, 9,
	-3,-3, 2, 10,
	-1,-6,-5,-7, 13,
	-2, 1, 0,-1,-5, 9,
	-2,-1,-1, 2,-7, 3, 8,
	 0,-4,-1,-3,-6,-4,-4, 9,
	-3, 0, 1,-2,-7, 1, 0,-4, 12,
	-3,-5,-6,-7,-2,-5,-6,-7,-6, 7,
	-3,-4,-6,-7,-3,-4,-6,-7,-5, 2, 6,
	-1, 3, 0,-2,-6, 2, 1,-3,-1,-5,-4, 8,
	-2,-3,-4,-6,-3,-1,-4,-5,-4, 2, 3,-3, 9,
	-4,-5,-6,-6,-4,-5,-6,-6,-2,-1, 0,-5, 0, 10,
	-1,-3,-4,-3,-6,-3,-2,-5,-4,-5,-5,-2,-4,-6, 12,
	 2,-2, 1,-1,-2,-1,-1,-1,-2,-4,-4,-1,-3,-4,-2, 7,
	 0,-2, 0,-2,-2,-1,-2,-3,-3,-2,-3,-1,-1,-4,-3, 2, 8,
	-5,-5,-7,-8,-5,-4,-6,-6,-4,-5,-4,-6,-3, 0,-7,-6,-5, 16,
	-4,-4,-4,-6,-5,-3,-5,-6, 3,-3,-2,-4,-3, 4,-6,-3,-3, 3, 11,
	-1,-4,-5,-6,-2,-4,-4,-6,-5, 4, 1,-4, 1,-2,-4,-3, 0,-5,-3, 7,
	-3,-2, 5, 6,-6,-1, 1,-2,-1,-6,-7,-1,-5,-6,-4, 0,-1,-8,-5,-6, 6,
	-2, 0,-1, 1,-7, 5, 6,-4, 0,-6,-5, 1,-3,-6,-2,-1,-2,-5,-4,-4, 0, 6,
	-1,-2,-2,-3,-4,-2,-2,-3,-2,-2,-2,-2,-2,-3,-3,-1,-1,-5,-3,-2,-3,-1,-2,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//  Matrix made by matblas from blosum85.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 85
	//  Entropy =   1.0805, Expected =  -0.8153
	public final String blosum85_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum85_50 =  { 
	 5,
	-2, 6,
	-2,-1, 7,
	-2,-2, 1, 7,
	-1,-4,-4,-5, 9,
	-1, 1, 0,-1,-4, 6,
	-1,-1,-1, 1,-5, 2, 6,
	 0,-3,-1,-2,-4,-3,-3, 6,
	-2, 0, 0,-2,-5, 1,-1,-3, 8,
	-2,-4,-4,-5,-2,-4,-4,-5,-4, 5,
	-2,-3,-4,-5,-2,-3,-4,-5,-3, 1, 4,
	-1, 2, 0,-1,-4, 1, 0,-2,-1,-3,-3, 6,
	-2,-2,-3,-4,-2, 0,-3,-4,-3, 1, 2,-2, 7,
	-3,-4,-4,-4,-3,-4,-4,-4,-2,-1, 0,-4,-1, 7,
	-1,-2,-3,-2,-4,-2,-2,-3,-3,-4,-4,-2,-3,-4, 8,
	 1,-1, 0,-1,-2,-1,-1,-1,-1,-3,-3,-1,-2,-3,-1, 5,
	 0,-2, 0,-2,-2,-1,-1,-2,-2,-1,-2,-1,-1,-3,-2, 1, 5,
	-3,-4,-5,-6,-4,-3,-4,-4,-3,-3,-3,-5,-2, 0,-5,-4,-4, 11,
	-3,-3,-3,-4,-3,-2,-4,-5, 2,-2,-2,-3,-2, 3,-4,-2,-2, 2, 7,
	-1,-3,-4,-4,-1,-3,-3,-4,-4, 3, 0,-3, 0,-1,-3,-2, 0,-3,-2, 5,
	-2,-2, 4, 4,-4,-1, 0,-1,-1,-5,-5,-1,-4,-4,-3, 0,-1,-5,-4,-4, 4,
	-1, 0,-1, 1,-5, 4, 4,-3, 0,-4,-4, 1,-2,-4,-2,-1,-1,-4,-3,-3, 0, 4,
	-1,-2,-2,-2,-3,-1,-1,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-2,
	-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
	};


	//  Matrix made by matblas from blosum85.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 85
	//  Entropy =   1.0805, Expected =  -0.8153
	public final String blosum85_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum85 =  { 
	 5,
	-2, 6,
	-2,-1, 7,
	-2,-2, 1, 7,
	-1,-4,-4,-5, 9,
	-1, 1, 0,-1,-4, 6,
	-1,-1,-1, 1,-5, 2, 6,
	 0,-3,-1,-2,-4,-3,-3, 6,
	-2, 0, 0,-2,-5, 1,-1,-3, 8,
	-2,-4,-4,-5,-2,-4,-4,-5,-4, 5,
	-2,-3,-4,-5,-2,-3,-4,-5,-3, 1, 4,
	-1, 2, 0,-1,-4, 1, 0,-2,-1,-3,-3, 6,
	-2,-2,-3,-4,-2, 0,-3,-4,-3, 1, 2,-2, 7,
	-3,-4,-4,-4,-3,-4,-4,-4,-2,-1, 0,-4,-1, 7,
	-1,-2,-3,-2,-4,-2,-2,-3,-3,-4,-4,-2,-3,-4, 8,
	 1,-1, 0,-1,-2,-1,-1,-1,-1,-3,-3,-1,-2,-3,-1, 5,
	 0,-2, 0,-2,-2,-1,-1,-2,-2,-1,-2,-1,-1,-3,-2, 1, 5,
	-3,-4,-5,-6,-4,-3,-4,-4,-3,-3,-3,-5,-2, 0,-5,-4,-4, 11,
	-3,-3,-3,-4,-3,-2,-4,-5, 2,-2,-2,-3,-2, 3,-4,-2,-2, 2, 7,
	-1,-3,-4,-4,-1,-3,-3,-4,-4, 3, 0,-3, 0,-1,-3,-2, 0,-3,-2, 5,
	-2,-2, 4, 4,-4,-1, 0,-1,-1,-5,-5,-1,-4,-4,-3, 0,-1,-5,-4,-4, 4,
	-1, 0,-1, 1,-5, 4, 4,-3, 0,-4,-4, 1,-2,-4,-2,-1,-1,-4,-3,-3, 0, 4,
	-1,-2,-2,-2,-3,-1,-1,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-2,
	-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
	};


	//  Matrix made by matblas from blosum90.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 90
	//  Entropy =   1.1806, Expected =  -0.8887
	public final String blosum90_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum90_50 =  { 
	 5,
	-2, 6,
	-2,-1, 7,
	-3,-3, 1, 7,
	-1,-5,-4,-5, 9,
	-1, 1, 0,-1,-4, 7,
	-1,-1,-1, 1,-6, 2, 6,
	 0,-3,-1,-2,-4,-3,-3, 6,
	-2, 0, 0,-2,-5, 1,-1,-3, 8,
	-2,-4,-4,-5,-2,-4,-4,-5,-4, 5,
	-2,-3,-4,-5,-2,-3,-4,-5,-4, 1, 5,
	-1, 2, 0,-1,-4, 1, 0,-2,-1,-4,-3, 6,
	-2,-2,-3,-4,-2, 0,-3,-4,-3, 1, 2,-2, 7,
	-3,-4,-4,-5,-3,-4,-5,-5,-2,-1, 0,-4,-1, 7,
	-1,-3,-3,-3,-4,-2,-2,-3,-3,-4,-4,-2,-3,-4, 8,
	 1,-1, 0,-1,-2,-1,-1,-1,-2,-3,-3,-1,-2,-3,-2, 5,
	 0,-2, 0,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1,-3,-2, 1, 6,
	-4,-4,-5,-6,-4,-3,-5,-4,-3,-4,-3,-5,-2, 0,-5,-4,-4, 11,
	-3,-3,-3,-4,-4,-3,-4,-5, 1,-2,-2,-3,-2, 3,-4,-3,-2, 2, 8,
	-1,-3,-4,-5,-2,-3,-3,-5,-4, 3, 0,-3, 0,-2,-3,-2,-1,-3,-3, 5,
	-2,-2, 4, 4,-4,-1, 0,-2,-1,-5,-5,-1,-4,-4,-3, 0,-1,-6,-4,-4, 4,
	-1, 0,-1, 0,-5, 4, 4,-3, 0,-4,-4, 1,-2,-4,-2,-1,-1,-4,-3,-3, 0, 4,
	-1,-2,-2,-2,-3,-1,-2,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-2,-2,-1,-2,
	-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
	};


	//  Matrix made by matblas from blosum90.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= 90
	//  Entropy =   1.1806, Expected =  -0.8887
	public final String blosum90_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosum90 =  { 
	 5,
	-2, 6,
	-2,-1, 7,
	-3,-3, 1, 7,
	-1,-5,-4,-5, 9,
	-1, 1, 0,-1,-4, 7,
	-1,-1,-1, 1,-6, 2, 6,
	 0,-3,-1,-2,-4,-3,-3, 6,
	-2, 0, 0,-2,-5, 1,-1,-3, 8,
	-2,-4,-4,-5,-2,-4,-4,-5,-4, 5,
	-2,-3,-4,-5,-2,-3,-4,-5,-4, 1, 5,
	-1, 2, 0,-1,-4, 1, 0,-2,-1,-4,-3, 6,
	-2,-2,-3,-4,-2, 0,-3,-4,-3, 1, 2,-2, 7,
	-3,-4,-4,-5,-3,-4,-5,-5,-2,-1, 0,-4,-1, 7,
	-1,-3,-3,-3,-4,-2,-2,-3,-3,-4,-4,-2,-3,-4, 8,
	 1,-1, 0,-1,-2,-1,-1,-1,-2,-3,-3,-1,-2,-3,-2, 5,
	 0,-2, 0,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1,-3,-2, 1, 6,
	-4,-4,-5,-6,-4,-3,-5,-4,-3,-4,-3,-5,-2, 0,-5,-4,-4, 11,
	-3,-3,-3,-4,-4,-3,-4,-5, 1,-2,-2,-3,-2, 3,-4,-3,-2, 2, 8,
	-1,-3,-4,-5,-2,-3,-3,-5,-4, 3, 0,-3, 0,-2,-3,-2,-1,-3,-3, 5,
	-2,-2, 4, 4,-4,-1, 0,-2,-1,-5,-5,-1,-4,-4,-3, 0,-1,-6,-4,-4, 4,
	-1, 0,-1, 0,-5, 4, 4,-3, 0,-4,-4, 1,-2,-4,-2,-1,-1,-4,-3,-3, 0, 4,
	-1,-2,-2,-2,-3,-1,-2,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-2,-2,-1,-2,
	-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6, 1
	};


	//  Matrix made by matblas from blosumn.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= -2
	//  Entropy =   1.5172, Expected =  -1.1484
	public final String blosumn_50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosumn_50 =  { 
	 6,
	-2, 7,
	-2,-1, 7,
	-3,-3, 1, 7,
	-2,-6,-4,-6, 9,
	-1, 0,-1,-2,-5, 7,
	-2,-2,-1, 1,-7, 1, 6,
	-1,-4,-2,-3,-5,-4,-4, 6,
	-3,-1, 0,-2,-6, 0,-1,-4, 9,
	-3,-5,-5,-6,-2,-4,-5,-6,-5, 6,
	-3,-4,-5,-6,-3,-3,-5,-6,-4, 1, 5,
	-2, 2,-1,-2,-5, 1, 0,-3,-2,-4,-4, 6,
	-2,-3,-4,-5,-3,-1,-4,-5,-3, 1, 2,-2, 8,
	-4,-4,-5,-5,-3,-4,-5,-5,-3,-1, 0,-4,-1, 7,
	-1,-3,-4,-3,-5,-2,-3,-4,-4,-5,-5,-2,-4,-5, 8,
	 1,-2, 0,-2,-2,-1,-1,-1,-2,-4,-4,-1,-3,-4,-2, 6,
	-1,-2,-1,-2,-2,-2,-2,-3,-3,-2,-3,-2,-2,-3,-3, 1, 6,
	-4,-5,-6,-7,-5,-4,-5,-5,-4,-4,-4,-6,-2, 0,-5,-4,-5, 11,
	-4,-4,-4,-5,-4,-3,-4,-6, 1,-3,-3,-4,-3, 3,-5,-3,-3, 1, 8,
	-1,-4,-4,-5,-2,-4,-4,-5,-5, 2, 0,-4, 0,-2,-4,-3,-1,-3,-3, 5,
	-3,-2, 4, 4,-5,-1, 0,-2,-1,-5,-5,-1,-5,-5,-4,-1,-2,-6,-4,-5, 4,
	-2,-1,-1, 0,-6, 4, 5,-4,-1,-5,-4, 0,-3,-5,-3,-1,-2,-4,-4,-4, 1, 4,
	-1,-2,-2,-3,-4,-2,-2,-3,-3,-2,-2,-2,-2,-3,-3,-1,-1,-4,-3,-2,-2,-2,-2,
	-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
	};


	//  Matrix made by matblas from blosumn.iij
	//  * column uses minimum score
	//  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
	//  Blocks Database = /data/blocks_5.0/blocks.dat
	//  Cluster Percentage: >= -2
	//  Entropy =   1.5172, Expected =  -1.1484
	public final String blosumn_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] blosumn =  { 
	 6,
	-2, 7,
	-2,-1, 7,
	-3,-3, 1, 7,
	-2,-6,-4,-6, 9,
	-1, 0,-1,-2,-5, 7,
	-2,-2,-1, 1,-7, 1, 6,
	-1,-4,-2,-3,-5,-4,-4, 6,
	-3,-1, 0,-2,-6, 0,-1,-4, 9,
	-3,-5,-5,-6,-2,-4,-5,-6,-5, 6,
	-3,-4,-5,-6,-3,-3,-5,-6,-4, 1, 5,
	-2, 2,-1,-2,-5, 1, 0,-3,-2,-4,-4, 6,
	-2,-3,-4,-5,-3,-1,-4,-5,-3, 1, 2,-2, 8,
	-4,-4,-5,-5,-3,-4,-5,-5,-3,-1, 0,-4,-1, 7,
	-1,-3,-4,-3,-5,-2,-3,-4,-4,-5,-5,-2,-4,-5, 8,
	 1,-2, 0,-2,-2,-1,-1,-1,-2,-4,-4,-1,-3,-4,-2, 6,
	-1,-2,-1,-2,-2,-2,-2,-3,-3,-2,-3,-2,-2,-3,-3, 1, 6,
	-4,-5,-6,-7,-5,-4,-5,-5,-4,-4,-4,-6,-2, 0,-5,-4,-5, 11,
	-4,-4,-4,-5,-4,-3,-4,-6, 1,-3,-3,-4,-3, 3,-5,-3,-3, 1, 8,
	-1,-4,-4,-5,-2,-4,-4,-5,-5, 2, 0,-4, 0,-2,-4,-3,-1,-3,-3, 5,
	-3,-2, 4, 4,-5,-1, 0,-2,-1,-5,-5,-1,-5,-5,-4,-1,-2,-6,-4,-5, 4,
	-2,-1,-1, 0,-6, 4, 5,-4,-1,-5,-4, 0,-3,-5,-3,-1,-2,-4,-4,-4, 1, 4,
	-1,-2,-2,-3,-4,-2,-2,-3,-3,-2,-2,-2,-2,-3,-3,-1,-1,-4,-3,-2,-2,-2,-2,
	-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
	};

}

