
/*
 * 
 *  file:  ./src/edu/virginia/bioch/scoringmatrices/OtherMatrices.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.scoringmatrices;

//===================================================================
//
// Scoring Matrices delivered with BLAST and Java-ized.
//
//===================================================================


import java.lang.*;

interface OtherMatrices
{

	//Date: Wed, 18 Sep 91 17:36:51 EDT
	//From: altschul@ray.nlm.nih.gov (Stephen Altschul)
	//To: gish@ray.nlm.nih.gov
	//Subject: Vanilla-flavored PAM-250
	//
	// substitution scores for B, Z, X, and * were obtained with "pam" version 1.0.5
	//
	public final String dayhoff_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] dayhoff =  { 
	 2,
	-2, 6,
	 0, 0, 2,
	 0,-1, 2, 4,
	-2,-4,-4,-5, 12,
	 0, 1, 1, 2,-5, 4,
	 0,-1, 1, 3,-5, 2, 4,
	 1,-3, 0, 1,-3,-1, 0, 5,
	-1, 2, 2, 1,-3, 3, 1,-2, 6,
	-1,-2,-2,-2,-2,-2,-2,-3,-2, 5,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,
	-1, 3, 1, 0,-5, 1, 0,-2, 0,-2,-3, 5,
	-1, 0,-2,-3,-5,-1,-2,-3,-2, 2, 4, 0, 6,
	-4,-4,-4,-6,-4,-5,-5,-5,-2, 1, 2,-5, 0, 9,
	 1, 0,-1,-1,-3, 0,-1,-1, 0,-2,-3,-1,-2,-5, 6,
	 1, 0, 1, 0, 0,-1, 0, 1,-1,-1,-3, 0,-2,-3, 1, 2,
	 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 3,
	-6, 2,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 0,-6,-2,-5, 17,
	-3,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-4,-2, 7,-5,-3,-3, 0, 10,
	 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
	 0,-1, 2, 3,-4, 1, 3, 0, 1,-2,-3, 1,-2,-4,-1, 0, 0,-5,-3,-2, 3,
	 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-3, 0,-2,-5, 0, 0,-1,-6,-4,-2, 2, 3,
	 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1,-1,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};



	// PAM 250 matrix recommended by Gonnet, Cohen & Benner
	// Science June 5, 1992.
	// Values rounded to nearest integer
	public final String gonnet_Alphabet = "CSTPAGNDEQHRKMILVFYWX*";
	public final int[] gonnet =  { 
	 12,
	 0, 2,
	 0, 2, 2,
	-3, 0, 0, 8,
	 0, 1, 1, 0, 2,
	-2, 0,-1,-2, 0, 7,
	-2, 1, 0,-1, 0, 0, 4,
	-3, 0, 0,-1, 0, 0, 2, 5,
	-3, 0, 0, 0, 0,-1, 1, 3, 4,
	-2, 0, 0, 0, 0,-1, 1, 1, 2, 3,
	-1, 0, 0,-1,-1,-1, 1, 0, 0, 1, 6,
	-2, 0, 0,-1,-1,-1, 0, 0, 0, 2, 1, 5,
	-3, 0, 0,-1, 0,-1, 1, 0, 1, 2, 1, 3, 3,
	-1,-1,-1,-2,-1,-4,-2,-3,-2,-1,-1,-2,-1, 4,
	-1,-2,-1,-3,-1,-4,-3,-4,-3,-2,-2,-2,-2, 2, 4,
	-2,-2,-1,-2,-1,-4,-3,-4,-3,-2,-2,-2,-2, 3, 3, 4,
	 0,-1, 0,-2, 0,-3,-2,-3,-2,-2,-2,-2,-2, 2, 3, 2, 3,
	-1,-3,-2,-4,-2,-5,-3,-4,-4,-3, 0,-3,-3, 2, 1, 2, 0, 7,
	 0,-2,-2,-3,-2,-4,-1,-3,-3,-2, 2,-2,-2, 0,-1, 0,-1, 5, 8,
	-1,-3,-4,-5,-4,-4,-4,-5,-4,-3,-1,-2,-4,-1,-2,-1,-3, 4, 4, 14,
	-3, 0, 0,-1, 0,-1, 0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-4,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	public final String identity_Alphabet = "ARNBDCQZEGHILKMFPSTWYVX*";
	public final int[] identity =  { 
	 1,
	-10000, 1,
	-10000,-10000, 1,
	-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 1,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 0,
	-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000,-10000, 0
	};



	public final String match_Alphabet = "ARNBDCQZEGHILKMFPSTWYVX*";
	public final int[] match =  { 
	 1,
	-1, 1,
	-1,-1, 1,
	-1,-1,-1, 1,
	-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 0,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 0
	};
}
