
/*
 * 
 *  file:  ./src/edu/virginia/bioch/scoringmatrices/PamMatrices1.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.scoringmatrices;

//===================================================================
//
// Scoring Matrices delivered with BLAST and Java-ized.
//
//===================================================================


import java.lang.*;

interface PamMatrices1
{

	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 310 substitution matrix, scale = ln(2)/4 = 0.173287
	//
	// Expected score = -0.779, Entropy = 0.238 bits
	//
	// Lowest score = -9, Highest score = 22
	//
	public final String pam310_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam310 =  { 
	 2,
	-1, 6,
	 0, 0, 2,
	 0,-1, 2, 4,
	-2,-4,-4,-5, 15,
	 0, 1, 1, 2,-6, 4,
	 0,-1, 2, 4,-6, 3, 4,
	 1,-2, 1, 1,-3,-1, 1, 5,
	-1, 2, 2, 1,-4, 3, 1,-2, 7,
	 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 7,
	-1, 4, 1, 0,-6, 1, 0,-1, 0,-2,-3, 5,
	-1, 0,-2,-2,-6,-1,-2,-3,-2, 3, 4, 0, 6,
	-4,-5,-4,-6,-4,-5,-6,-5,-2, 1, 3,-5, 1, 11,
	 1, 0, 0,-1,-3, 0, 0, 0, 0,-2,-3,-1,-2,-5, 6,
	 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-2,-4, 1, 1,
	 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 1, 1, 2,
	-6, 3,-4,-7,-9,-5,-7,-8,-3,-5,-2,-3,-4, 1,-6,-3,-6, 22,
	-4,-4,-2,-5, 1,-4,-5,-6, 0,-1, 0,-5,-2, 9,-5,-3,-3, 0, 12,
	 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-7,-2, 4,
	 0, 0, 2, 3,-5, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 3,
	 0, 0, 1, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-6,-4,-2, 2, 3,
	 0,-1, 0,-1,-3, 0,-1,-1, 0,-1,-1,-1,-1,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 320 substitution matrix, scale = ln(2)/4 = 0.173287
	//
	// Expected score = -0.741, Entropy = 0.224 bits
	//
	// Lowest score = -8, Highest score = 22
	//
	public final String pam320_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam320 =  { 
	 1,
	-1, 6,
	 0, 0, 2,
	 1,-1, 2, 4,
	-2,-4,-4,-5, 15,
	 0, 1, 1, 2,-5, 4,
	 0,-1, 2, 3,-5, 2, 4,
	 1,-2, 1, 1,-3,-1, 1, 5,
	-1, 2, 2, 1,-4, 3, 1,-2, 6,
	 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 7,
	-1, 4, 1, 0,-6, 1, 0,-1, 0,-2,-3, 5,
	-1, 0,-2,-2,-5,-1,-2,-3,-2, 2, 4, 0, 6,
	-4,-5,-4,-6,-4,-5,-5,-5,-2, 1, 3,-5, 1, 11,
	 1, 0, 0, 0,-3, 0, 0, 0, 0,-2,-2,-1,-2,-5, 6,
	 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-1,-3, 1, 1,
	 1,-1, 0, 0,-2, 0, 0, 0,-1, 0,-2, 0,-1,-3, 1, 1, 2,
	-6, 3,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 1,-6,-3,-5, 22,
	-4,-4,-2,-5, 1,-4,-5,-5, 0,-1, 0,-5,-2, 9,-5,-3,-3, 1, 12,
	 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
	 0, 0, 2, 3,-4, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-3,-2, 2,
	 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-6,-4,-2, 2, 3,
	 0,-1, 0,-1,-3, 0, 0,-1, 0, 0,-1,-1, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 330 substitution matrix, scale = ln(2)/4 = 0.173287
	//
	// Expected score = -0.693, Entropy = 0.210 bits
	//
	// Lowest score = -8, Highest score = 22
	//
	public final String pam330_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam330 =  { 
	 1,
	-1, 6,
	 0, 0, 2,
	 1,-1, 2, 3,
	-2,-4,-4,-5, 15,
	 0, 1, 1, 2,-5, 3,
	 0,-1, 2, 3,-5, 2, 3,
	 1,-2, 1, 1,-3,-1, 1, 5,
	-1, 2, 1, 1,-3, 3, 1,-2, 6,
	 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 6,
	-1, 4, 1, 0,-5, 1, 0,-1, 0,-2,-3, 5,
	-1, 0,-1,-2,-5,-1,-2,-2,-2, 2, 4, 0, 5,
	-3,-4,-3,-5,-4,-4,-5,-5,-2, 1, 3,-5, 1, 10,
	 1, 0, 0, 0,-3, 0, 0, 0, 0,-2,-2,-1,-2,-5, 6,
	 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-1,-3, 1, 1,
	 1,-1, 0, 0,-2, 0, 0, 0,-1, 0,-1, 0, 0,-3, 1, 1, 2,
	-6, 3,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 1,-6,-3,-5, 22,
	-3,-4,-2,-4, 1,-4,-4,-5, 0, 0, 0,-4,-2, 9,-5,-3,-3, 1, 12,
	 0,-2,-1,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
	 0, 0, 2, 3,-4, 1, 2, 1, 1,-2,-3, 1,-2,-4, 0, 1, 0,-5,-3,-2, 2,
	 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-2, 2, 3,
	 0,-1, 0, 0,-3, 0, 0,-1, 0, 0,-1,-1, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 340 substitution matrix, scale = ln(2)/4 = 0.173287
	//
	// Expected score = -0.680, Entropy = 0.198 bits
	//
	// Lowest score = -8, Highest score = 22
	//
	public final String pam340_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam340 =  { 
	 1,
	-1, 6,
	 0, 0, 1,
	 1,-1, 2, 3,
	-2,-4,-3,-5, 15,
	 0, 1, 1, 2,-5, 3,
	 0, 0, 1, 3,-5, 2, 3,
	 1,-2, 1, 1,-3,-1, 1, 4,
	-1, 2, 1, 1,-3, 3, 1,-2, 6,
	 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 6,
	-1, 4, 1, 0,-5, 1, 0,-1, 0,-2,-3, 4,
	-1, 0,-1,-2,-5,-1,-2,-2,-2, 2, 4, 0, 5,
	-3,-4,-3,-5,-4,-4,-5,-5,-2, 1, 3,-5, 1, 10,
	 1, 0, 0, 0,-3, 0, 0, 0, 0,-2,-2,-1,-2,-4, 5,
	 1, 0, 1, 0, 0, 0, 0, 1, 0,-1,-2, 0,-1,-3, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 0,-1, 0,-1, 0, 0,-3, 1, 1, 2,
	-6, 3,-4,-7,-8,-5,-7,-7,-2,-5,-2,-3,-4, 1,-5,-3,-5, 22,
	-3,-4,-2,-4, 1,-4,-4,-5, 0, 0, 0,-4,-2, 9,-5,-3,-3, 1, 12,
	 0,-2,-1,-2,-2,-2,-1,-1,-2, 3, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
	 0, 0, 2, 3,-4, 1, 2, 1, 1,-2,-3, 1,-2,-4, 0, 1, 0,-5,-3,-2, 2,
	 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-2, 2, 3,
	 0,-1, 0, 0,-3, 0, 0,-1, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 350 substitution matrix, scale = ln(2)/5 = 0.138629
	//
	// Expected score = -0.701, Entropy = 0.186 bits
	//
	// Lowest score = -10, Highest score = 27
	//
	public final String pam350_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam350 =  { 
	 2,
	-1, 7,
	 0, 1, 2,
	 1,-1, 2, 4,
	-2,-4,-4,-6, 18,
	 0, 2, 1, 2,-6, 4,
	 1, 0, 2, 4,-6, 3, 4,
	 2,-2, 1, 1,-4,-1, 1, 5,
	-1, 2, 2, 1,-4, 3, 1,-2, 7,
	 0,-2,-2,-2,-3,-2,-2,-2,-2, 5,
	-2,-3,-3,-4,-7,-2,-4,-4,-2, 4, 8,
	-1, 4, 1, 1,-6, 1, 0,-1, 1,-2,-3, 5,
	-1, 0,-2,-3,-6,-1,-2,-3,-2, 3, 5, 0, 6,
	-4,-5,-4,-6,-5,-5,-6,-6,-2, 2, 3,-6, 1, 13,
	 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-3,-1,-2,-5, 6,
	 1, 0, 1, 1, 0, 0, 0, 1,-1,-1,-3, 0,-2,-4, 1, 1,
	 1,-1, 1, 0,-2, 0, 0, 1,-1, 0,-2, 0,-1,-3, 1, 1, 2,
	-7, 4,-5,-8,-10,-5,-8,-8,-3,-6,-2,-4,-5, 1,-7,-3,-6, 27,
	-4,-5,-3,-5, 1,-5,-5,-6, 0, 0, 0,-5,-2, 11,-6,-3,-3, 1, 14,
	 0,-3,-2,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2,-1,-1,-1, 0,-7,-2, 5,
	 1, 0, 2, 3,-5, 2, 3, 1, 1,-2,-4, 1,-2,-5, 0, 1, 0,-6,-4,-2, 3,
	 0, 1, 2, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-6, 0, 0, 0,-7,-5,-2, 2, 3,
	 0,-1, 0,-1,-3, 0, 0,-1, 0, 0,-1,-1, 0,-2, 0, 0, 0,-5,-2, 0, 0, 0,-1,
	-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 360 substitution matrix, scale = ln(2)/5 = 0.138629
	//
	// Expected score = -0.697, Entropy = 0.175 bits
	//
	// Lowest score = -9, Highest score = 27
	//
	public final String pam360_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam360 =  { 
	 1,
	-1, 6,
	 0, 1, 2,
	 1,-1, 2, 4,
	-2,-4,-4,-6, 18,
	 0, 2, 1, 2,-6, 3,
	 1, 0, 2, 4,-6, 3, 4,
	 2,-2, 1, 1,-4,-1, 1, 5,
	-1, 2, 2, 1,-4, 3, 1,-2, 7,
	 0,-2,-2,-2,-3,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-7,-2,-3,-4,-2, 3, 7,
	-1, 4, 1, 1,-6, 1, 0,-1, 1,-2,-3, 5,
	-1, 0,-2,-2,-6,-1,-2,-3,-2, 3, 5, 0, 6,
	-4,-5,-4,-6,-4,-5,-6,-6,-2, 2, 3,-6, 1, 12,
	 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-3,-1,-2,-5, 6,
	 1, 0, 1, 1, 0, 0, 0, 1, 0,-1,-3, 0,-2,-4, 1, 1,
	 1, 0, 1, 0,-2, 0, 0, 1,-1, 0,-2, 0,-1,-3, 1, 1, 2,
	-7, 4,-5,-8,-9,-5,-8,-8,-3,-6,-2,-4,-4, 2,-6,-3,-6, 27,
	-4,-5,-3,-5, 1,-4,-5,-6, 0, 0, 0,-5,-2, 11,-5,-3,-3, 1, 14,
	 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2,-1,-1,-1, 0,-7,-2, 4,
	 1, 0, 2, 3,-5, 2, 3, 1, 1,-2,-4, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
	 0, 1, 2, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-7,-5,-2, 2, 3,
	 0,-1, 0, 0,-3, 0, 0,-1, 0, 0,-1,-1, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 370 substitution matrix, scale = ln(2)/5 = 0.138629
	//
	// Expected score = -0.649, Entropy = 0.165 bits
	//
	// Lowest score = -9, Highest score = 27
	//
	public final String pam370_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam370 =  { 
	 1,
	-1, 6,
	 0, 1, 2,
	 1, 0, 2, 4,
	-2,-4,-4,-5, 18,
	 0, 2, 1, 2,-6, 3,
	 1, 0, 2, 3,-6, 2, 3,
	 2,-2, 1, 1,-3,-1, 1, 5,
	-1, 2, 2, 1,-4, 3, 1,-2, 6,
	 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 7,
	-1, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 5,
	-1, 0,-2,-2,-6,-1,-2,-3,-2, 3, 5, 0, 5,
	-4,-5,-4,-6,-4,-5,-6,-5,-2, 2, 3,-6, 1, 12,
	 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-3,-1,-2,-5, 6,
	 1, 0, 1, 1, 0, 0, 0, 1, 0,-1,-3, 0,-1,-4, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 2,
	-7, 3,-5,-7,-9,-5,-8,-8,-3,-5,-2,-3,-4, 2,-6,-3,-6, 27,
	-4,-4,-3,-5, 1,-4,-5,-6, 0, 0, 0,-5,-2, 11,-5,-3,-3, 1, 14,
	 0,-2,-1,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-7,-2, 4,
	 1, 0, 2, 3,-5, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
	 0, 1, 1, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-6,-5,-2, 2, 3,
	 0,-1, 0, 0,-3, 0, 0,-1, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 380 substitution matrix, scale = ln(2)/5 = 0.138629
	//
	// Expected score = -0.612, Entropy = 0.156 bits
	//
	// Lowest score = -9, Highest score = 26
	//
	public final String pam380_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam380 =  { 
	 1,
	-1, 6,
	 0, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-4,-5, 17,
	 0, 2, 1, 2,-5, 3,
	 1, 0, 2, 3,-5, 2, 3,
	 2,-2, 1, 1,-3,-1, 1, 5,
	-1, 2, 1, 1,-4, 3, 1,-1, 6,
	 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 7,
	-1, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 5,
	-1, 0,-1,-2,-5,-1,-2,-2,-2, 3, 4, 0, 5,
	-4,-5,-4,-6,-4,-5,-5,-5,-2, 2, 3,-5, 1, 12,
	 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-2, 0,-2,-5, 5,
	 1, 0, 1, 1, 0, 0, 0, 1, 0,-1,-3, 0,-1,-4, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 2,
	-6, 3,-5,-7,-9,-5,-7,-8,-3,-5,-2,-3,-4, 2,-6,-3,-6, 26,
	-4,-4,-3,-5, 1,-4,-5,-5, 0, 0, 0,-5,-2, 10,-5,-3,-3, 1, 13,
	 0,-2,-1,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-6,-2, 4,
	 1, 0, 2, 3,-4, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
	 0, 1, 1, 3,-5, 3, 3, 0, 2,-2,-3, 1,-1,-5, 0, 0, 0,-6,-4,-2, 2, 3,
	 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 390 substitution matrix, scale = ln(2)/5 = 0.138629
	//
	// Expected score = -0.581, Entropy = 0.147 bits
	//
	// Lowest score = -9, Highest score = 26
	//
	public final String pam390_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam390 =  { 
	 1,
	-1, 6,
	 0, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-4,-5, 17,
	 0, 1, 1, 2,-5, 3,
	 1, 0, 2, 3,-5, 2, 3,
	 1,-2, 1, 1,-3, 0, 1, 5,
	-1, 2, 1, 1,-4, 3, 1,-1, 6,
	 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 3, 7,
	-1, 4, 1, 1,-5, 1, 1,-1, 1,-2,-3, 4,
	-1, 0,-1,-2,-5,-1,-2,-2,-2, 3, 4, 0, 5,
	-3,-5,-4,-5,-4,-4,-5,-5,-2, 2, 3,-5, 1, 12,
	 1, 0, 0, 0,-3, 0, 0, 0, 0,-1,-2, 0,-2,-5, 5,
	 1, 0, 1, 1, 0, 0, 0, 1, 0,-1,-2, 0,-1,-3, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
	-6, 3,-4,-7,-9,-5,-7,-7,-3,-5,-2,-3,-4, 2,-6,-3,-5, 26,
	-4,-4,-3,-5, 1,-4,-5,-5, 0, 0, 0,-5,-1, 10,-5,-3,-3, 1, 13,
	 0,-2,-1,-2,-2,-1,-1,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-6,-2, 4,
	 1, 0, 2, 3,-4, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
	 0, 1, 1, 3,-5, 3, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-1, 2, 3,
	 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 40 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -4.27, Entropy = 2.26 bits
	//
	// Lowest score = -15, Highest score = 13
	//
	public final String pam40_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam40 =  { 
	 6,
	-6, 8,
	-3,-5, 7,
	-3,-9, 2, 7,
	-6,-7,-9,-12, 9,
	-3,-1,-3,-2,-12, 8,
	-2,-8,-1, 3,-12, 2, 7,
	-1,-8,-2,-3,-8,-6,-3, 6,
	-6,-1, 1,-3,-7, 1,-4,-8, 9,
	-4,-5,-4,-6,-5,-7,-5,-9,-8, 8,
	-5,-8,-6,-11,-13,-4,-8,-9,-5,-1, 7,
	-6, 1, 0,-4,-12,-2,-4,-6,-5,-5,-7, 6,
	-4,-3,-7,-9,-12,-3,-6,-7,-9, 0, 1,-1, 11,
	-7,-8,-8,-13,-11,-11,-12,-8,-5,-2,-2,-12,-3, 9,
	-1,-3,-5,-7,-7,-2,-5,-5,-3,-7,-6,-6,-7,-9, 8,
	 0,-2, 0,-3,-2,-4,-4,-1,-5,-6,-7,-3,-5,-6,-1, 6,
	 0,-5,-1,-4,-7,-5,-5,-5,-6,-2,-6,-2,-3,-8,-3, 1, 7,
	-12,-1,-7,-13,-14,-11,-15,-13,-6,-12,-5,-10,-11,-4,-12,-4,-11, 13,
	-7,-9,-4,-10,-3,-10,-8,-12,-3,-5,-6,-8,-10, 2,-12,-6,-6,-4, 10,
	-2,-7,-7,-7,-5,-6,-6,-5,-6, 2,-2,-8,-1,-7,-5,-5,-2,-14,-6, 7,
	-3,-6, 6, 6,-11,-2, 2,-2,-1,-5,-8,-2,-8,-9,-6,-1,-2,-9,-6,-7, 6,
	-2,-3,-2, 2,-12, 6, 6,-4, 0,-5,-6,-3,-4,-12,-3,-4,-5,-13,-8,-6, 1, 6,
	-3,-5,-3,-5,-8,-4,-4,-4,-4,-4,-5,-4,-4,-7,-4,-2,-3,-9,-7,-4,-4,-4,-4,
	-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 400 substitution matrix, scale = ln(2)/5 = 0.138629
	//
	// Expected score = -0.521, Entropy = 0.139 bits
	//
	// Lowest score = -8, Highest score = 26
	//
	public final String pam400_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam400 =  { 
	 1,
	-1, 5,
	 0, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-3,-5, 17,
	 0, 1, 1, 2,-5, 3,
	 1, 0, 2, 3,-5, 2, 3,
	 1,-2, 1, 1,-3, 0, 1, 4,
	-1, 2, 1, 1,-3, 3, 1,-1, 5,
	 0,-2,-1,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-3,-6,-2,-3,-3,-2, 3, 7,
	-1, 4, 1, 1,-5, 1, 1,-1, 1,-2,-2, 4,
	-1, 0,-1,-2,-5,-1,-2,-2,-1, 2, 4, 0, 5,
	-3,-4,-3,-5,-4,-4,-5,-5,-2, 2, 3,-5, 1, 11,
	 1, 0, 0, 0,-2, 0, 0, 0, 0,-1,-2, 0,-1,-4, 5,
	 1, 0, 1, 1, 0, 0, 0, 1, 0,-1,-2, 0,-1,-3, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
	-6, 3,-4,-7,-8,-5,-7,-7,-2,-5,-2,-3,-4, 2,-6,-3,-5, 26,
	-3,-4,-3,-4, 1,-4,-4,-5, 0, 0, 0,-4,-1, 10,-5,-3,-3, 1, 13,
	 0,-2,-1,-2,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-2, 4,
	 1, 0, 2, 2,-4, 2, 2, 1, 1,-2,-3, 1,-2,-4, 0, 1, 0,-5,-3,-1, 2,
	 0, 1, 1, 2,-5, 2, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-1, 2, 3,
	 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 410 substitution matrix, scale = ln(2)/6 = 0.115525
	//
	// Expected score = -0.617, Entropy = 0.131 bits
	//
	// Lowest score = -10, Highest score = 31
	//
	public final String pam410_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam410 =  { 
	 1,
	-1, 6,
	 0, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-4,-6, 20,
	 0, 2, 1, 2,-6, 3,
	 1, 0, 2, 3,-6, 2, 3,
	 2,-2, 1, 1,-4, 0, 1, 5,
	-1, 2, 1, 1,-4, 3, 1,-1, 6,
	 0,-2,-2,-2,-3,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-7,-2,-3,-4,-2, 4, 8,
	-1, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 5,
	-1, 0,-2,-2,-6,-1,-2,-3,-2, 3, 5, 0, 5,
	-4,-5,-4,-6,-4,-5,-6,-6,-2, 2, 4,-6, 1, 14,
	 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-3, 0,-2,-5, 6,
	 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-3, 0,-1,-4, 1, 1,
	 1, 0, 1, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 2,
	-7, 4,-5,-8,-10,-5,-8,-8,-3,-6,-2,-3,-4, 2,-7,-3,-6, 31,
	-4,-5,-3,-5, 1,-4,-5,-6, 0, 0, 1,-5,-2, 12,-5,-3,-3, 2, 15,
	 0,-2,-1,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-7,-2, 4,
	 1, 0, 2, 3,-5, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
	 0, 1, 2, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-7,-5,-2, 2, 3,
	 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 420 substitution matrix, scale = ln(2)/6 = 0.115525
	//
	// Expected score = -0.599, Entropy = 0.124 bits
	//
	// Lowest score = -10, Highest score = 31
	//
	public final String pam420_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam420 =  { 
	 1,
	-1, 6,
	 0, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-4,-5, 20,
	 0, 2, 1, 2,-6, 3,
	 1, 0, 2, 3,-6, 2, 3,
	 2,-2, 1, 1,-3, 0, 1, 5,
	-1, 2, 1, 1,-4, 3, 1,-1, 6,
	 0,-2,-2,-2,-3,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-7,-2,-3,-4,-2, 4, 7,
	 0, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 5,
	-1, 0,-1,-2,-6,-1,-2,-2,-2, 3, 5, 0, 5,
	-4,-5,-4,-6,-4,-5,-6,-6,-2, 2, 4,-6, 1, 13,
	 1, 0, 0, 0,-3, 1, 0, 0, 0,-2,-2, 0,-2,-5, 5,
	 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-3, 0,-1,-4, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
	-7, 4,-5,-8,-10,-5,-8,-8,-3,-6,-2,-3,-4, 2,-6,-3,-6, 31,
	-4,-5,-3,-5, 1,-4,-5,-6, 0, 0, 1,-5,-1, 12,-5,-3,-3, 2, 15,
	 0,-2,-1,-2,-2,-2,-2,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-7,-2, 4,
	 1, 0, 2, 3,-5, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-2, 2,
	 0, 1, 2, 3,-6, 3, 3, 0, 2,-2,-3, 1,-1,-5, 0, 0, 0,-7,-5,-2, 2, 3,
	 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 430 substitution matrix, scale = ln(2)/6 = 0.115525
	//
	// Expected score = -0.543, Entropy = 0.117 bits
	//
	// Lowest score = -9, Highest score = 31
	//
	public final String pam430_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam430 =  { 
	 1,
	-1, 6,
	 0, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-4,-5, 20,
	 0, 2, 1, 2,-6, 3,
	 1, 0, 2, 3,-5, 2, 3,
	 2,-2, 1, 1,-3, 0, 1, 5,
	-1, 2, 1, 1,-4, 3, 1,-1, 5,
	 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 4, 7,
	 0, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 4,
	-1, 0,-1,-2,-5,-1,-2,-2,-1, 3, 5, 0, 5,
	-4,-5,-4,-6,-4,-5,-6,-5,-2, 2, 4,-5, 1, 13,
	 1, 0, 0, 0,-3, 1, 0, 0, 0,-1,-2, 0,-2,-5, 5,
	 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-4, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
	-7, 4,-5,-7,-9,-5,-8,-8,-3,-5,-2,-3,-4, 2,-6,-3,-6, 31,
	-4,-4,-3,-5, 1,-4,-5,-5, 0, 0, 1,-5,-1, 12,-5,-3,-3, 2, 15,
	 0,-2,-1,-2,-2,-1,-1,-1,-2, 4, 3,-2, 2, 0,-1,-1, 0,-7,-2, 4,
	 1, 0, 2, 3,-4, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-1, 2,
	 0, 1, 1, 3,-5, 3, 3, 0, 2,-2,-3, 1,-1,-5, 0, 0, 0,-6,-5,-1, 2, 3,
	 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 440 substitution matrix, scale = ln(2)/6 = 0.115525
	//
	// Expected score = -0.529, Entropy = 0.111 bits
	//
	// Lowest score = -9, Highest score = 30
	//
	public final String pam440_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam440 =  { 
	 1,
	-1, 5,
	 0, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-4,-5, 20,
	 0, 2, 1, 2,-5, 3,
	 1, 0, 2, 3,-5, 2, 3,
	 2,-2, 1, 1,-3, 0, 1, 4,
	-1, 2, 1, 1,-4, 3, 1,-1, 5,
	 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-3,-6,-2,-3,-4,-2, 4, 7,
	 0, 4, 1, 1,-5, 1, 1,-1, 1,-2,-3, 4,
	-1, 0,-1,-2,-5,-1,-2,-2,-1, 3, 5, 0, 4,
	-4,-5,-4,-6,-4,-4,-5,-5,-2, 2, 4,-5, 1, 13,
	 1, 0, 0, 0,-3, 1, 0, 0, 0,-1,-2, 0,-1,-5, 5,
	 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-4, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
	-6, 4,-5,-7,-9,-5,-7,-8,-3,-5,-2,-3,-4, 2,-6,-3,-6, 30,
	-4,-4,-3,-5, 1,-4,-5,-5, 0, 0, 1,-5,-1, 12,-5,-3,-3, 2, 15,
	 0,-2,-1,-2,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-2, 4,
	 1, 0, 2, 2,-4, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-1, 2,
	 0, 1, 1, 2,-5, 2, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-1, 2, 3,
	 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 450 substitution matrix, scale = ln(2)/6 = 0.115525
	//
	// Expected score = -0.476, Entropy = 0.105 bits
	//
	// Lowest score = -9, Highest score = 30
	//
	public final String pam450_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam450 =  { 
	 1,
	-1, 5,
	 0, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-4,-5, 20,
	 0, 2, 1, 2,-5, 3,
	 1, 0, 2, 3,-5, 2, 3,
	 1,-1, 1, 1,-3, 0, 1, 4,
	-1, 2, 1, 1,-4, 3, 1,-1, 5,
	 0,-2,-1,-2,-2,-1,-2,-2,-2, 4,
	-2,-3,-2,-3,-6,-2,-3,-3,-2, 3, 7,
	 0, 4, 1, 1,-5, 1, 1,-1, 1,-2,-2, 4,
	-1, 0,-1,-2,-5,-1,-2,-2,-1, 3, 4, 0, 4,
	-3,-4,-4,-5,-4,-4,-5,-5,-2, 2, 4,-5, 1, 13,
	 1, 0, 0, 0,-2, 1, 0, 0, 0,-1,-2, 0,-1,-5, 5,
	 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-3, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1,-1, 0,-1, 0, 0,-3, 1, 1, 1,
	-6, 4,-4,-7,-9,-5,-7,-8,-2,-5,-1,-3,-4, 2,-6,-3,-5, 30,
	-4,-4,-3,-5, 1,-4,-5,-5, 0, 0, 1,-5,-1, 12,-5,-3,-3, 2, 14,
	 0,-2,-1,-1,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-2, 3,
	 1, 0, 1, 2,-4, 2, 2, 1, 1,-2,-3, 1,-2,-4, 0, 1, 0,-6,-4,-1, 2,
	 0, 1, 1, 2,-5, 2, 3, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-1, 2, 2,
	 0, 0, 0, 0,-2, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 460 substitution matrix, scale = ln(2)/6 = 0.115525
	//
	// Expected score = -0.429, Entropy = 0.0994 bits
	//
	// Lowest score = -9, Highest score = 30
	//
	public final String pam460_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam460 =  { 
	 1,
	-1, 5,
	 0, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-3,-5, 19,
	 0, 1, 1, 2,-5, 2,
	 1, 0, 1, 3,-5, 2, 3,
	 1,-1, 1, 1,-3, 0, 1, 4,
	 0, 2, 1, 1,-3, 2, 1,-1, 5,
	 0,-2,-1,-2,-2,-1,-2,-2,-2, 3,
	-1,-2,-2,-3,-6,-2,-3,-3,-2, 3, 7,
	 0, 4, 1, 1,-5, 1, 1,-1, 1,-2,-2, 4,
	-1, 0,-1,-2,-5,-1,-2,-2,-1, 2, 4, 0, 4,
	-3,-4,-3,-5,-3,-4,-5,-5,-2, 2, 3,-5, 1, 12,
	 1, 0, 0, 0,-2, 1, 0, 1, 0,-1,-2, 0,-1,-4, 4,
	 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-3, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1, 0, 0,-1, 0, 0,-3, 1, 1, 1,
	-6, 4,-4,-7,-9,-5,-7,-7,-2,-5,-1,-3,-4, 2,-6,-3,-5, 30,
	-3,-4,-3,-4, 2,-4,-4,-5, 0, 0, 1,-4,-1, 11,-5,-3,-3, 2, 14,
	 0,-2,-1,-1,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-2, 3,
	 1, 0, 1, 2,-4, 1, 2, 1, 1,-2,-3, 1,-2,-4, 0, 1, 0,-6,-4,-1, 2,
	 0, 1, 1, 2,-5, 2, 2, 0, 2,-2,-2, 1,-1,-5, 0, 0, 0,-6,-4,-1, 2, 2,
	 0, 0, 0, 0,-2, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 470 substitution matrix, scale = ln(2)/7 = 0.0990210
	//
	// Expected score = -0.520, Entropy = 0.0942 bits
	//
	// Lowest score = -10, Highest score = 35
	//
	public final String pam470_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam470 =  { 
	 1,
	-1, 6,
	 1, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-4,-5, 22,
	 0, 2, 1, 2,-6, 3,
	 1, 0, 2, 3,-5, 2, 3,
	 2,-1, 1, 1,-3, 0, 1, 5,
	-1, 2, 1, 1,-4, 3, 1,-1, 5,
	 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 4, 8,
	 0, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 4,
	-1, 0,-1,-2,-6,-1,-2,-2,-1, 3, 5, 0, 4,
	-4,-5,-4,-6,-4,-5,-6,-6,-2, 2, 4,-5, 1, 14,
	 1, 0, 0, 0,-3, 1, 0, 1, 0,-1,-2, 0,-1,-5, 5,
	 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-4, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1, 0, 0,-1, 0, 0,-3, 1, 1, 1,
	-7, 4,-5,-8,-10,-5,-8,-8,-3,-5,-2,-3,-4, 3,-6,-4,-6, 35,
	-4,-5,-3,-5, 2,-4,-5,-6, 0, 0, 1,-5,-1, 13,-5,-3,-3, 2, 16,
	 0,-2,-1,-2,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-7,-2, 4,
	 1, 0, 2, 3,-5, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-1, 2,
	 0, 1, 1, 3,-6, 2, 3, 1, 2,-2,-3, 1,-1,-5, 1, 0, 0,-7,-5,-1, 2, 3,
	 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
	-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 480 substitution matrix, scale = ln(2)/7 = 0.0990210
	//
	// Expected score = -0.494, Entropy = 0.0893 bits
	//
	// Lowest score = -10, Highest score = 35
	//
	public final String pam480_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam480 =  { 
	 1,
	-1, 5,
	 1, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-4,-5, 22,
	 0, 2, 1, 2,-5, 3,
	 1, 0, 2, 3,-5, 2, 3,
	 2,-1, 1, 1,-3, 0, 1, 4,
	 0, 2, 1, 1,-4, 3, 1,-1, 5,
	 0,-2,-1,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-3,-6,-2,-3,-4,-2, 4, 7,
	 0, 4, 1, 1,-6, 1, 1,-1, 1,-2,-3, 4,
	-1, 0,-1,-2,-5,-1,-2,-2,-1, 3, 5, 0, 4,
	-4,-5,-4,-6,-4,-5,-5,-5,-2, 2, 4,-5, 1, 14,
	 1, 0, 0, 0,-3, 1, 0, 1, 0,-1,-2, 0,-1,-5, 5,
	 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-4, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1, 0, 0,-1, 0, 0,-3, 1, 1, 1,
	-7, 4,-5,-7,-10,-5,-8,-8,-3,-5,-2,-3,-4, 3,-6,-3,-6, 35,
	-4,-4,-3,-5, 2,-4,-5,-5, 0, 0, 1,-5,-1, 13,-5,-3,-3, 2, 16,
	 0,-2,-1,-1,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-7,-2, 3,
	 1, 0, 2, 2,-4, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-1, 2,
	 0, 1, 1, 2,-5, 2, 3, 1, 2,-2,-3, 1,-1,-5, 1, 0, 0,-6,-5,-1, 2, 2,
	 0, 0, 0, 0,-3, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
	-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 490 substitution matrix, scale = ln(2)/7 = 0.0990210
	//
	// Expected score = -0.431, Entropy = 0.0847 bits
	//
	// Lowest score = -9, Highest score = 34
	//
	public final String pam490_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam490 =  { 
	 1,
	-1, 5,
	 0, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-4,-5, 22,
	 0, 2, 1, 2,-5, 2,
	 1, 0, 2, 3,-5, 2, 3,
	 2,-1, 1, 1,-3, 0, 1, 4,
	 0, 2, 1, 1,-4, 2, 1,-1, 5,
	 0,-2,-1,-2,-2,-1,-2,-2,-2, 3,
	-1,-3,-2,-3,-6,-2,-3,-3,-2, 4, 7,
	 0, 4, 1, 1,-5, 1, 1,-1, 1,-2,-2, 4,
	-1, 0,-1,-2,-5,-1,-2,-2,-1, 3, 5, 0, 4,
	-3,-5,-4,-5,-4,-4,-5,-5,-2, 2, 4,-5, 1, 14,
	 1, 0, 0, 0,-3, 1, 0, 1, 0,-1,-2, 0,-1,-5, 4,
	 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-4, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1, 0, 0,-1, 0, 0,-3, 1, 1, 1,
	-6, 4,-5,-7,-9,-5,-7,-8,-3,-5,-1,-3,-4, 3,-6,-3,-6, 34,
	-4,-4,-3,-5, 2,-4,-5,-5, 0, 0, 1,-5,-1, 13,-5,-3,-3, 2, 15,
	 0,-2,-1,-1,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-2, 3,
	 1, 0, 1, 2,-4, 2, 2, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-6,-4,-1, 2,
	 0, 1, 1, 2,-5, 2, 2, 1, 2,-2,-2, 1,-1,-5, 1, 0, 0,-6,-4,-1, 2, 2,
	 0, 0, 0, 0,-2, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 50 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -3.70, Entropy = 2.00 bits
	//
	// Lowest score = -13, Highest score = 13
	//
	public final String pam50_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam50 =  { 
	 5,
	-5, 8,
	-2,-4, 7,
	-2,-7, 2, 7,
	-5,-6,-8,-11, 9,
	-3, 0,-2,-1,-11, 8,
	-1,-7,-1, 3,-11, 2, 7,
	-1,-7,-2,-2,-7,-5,-3, 6,
	-5, 0, 1,-2,-6, 2,-3,-7, 9,
	-3,-4,-4,-6,-5,-6,-4,-8,-7, 8,
	-5,-7,-6,-10,-12,-4,-7,-9,-5, 0, 6,
	-5, 1, 0,-3,-11,-2,-3,-6,-4,-5,-6, 6,
	-4,-3,-6,-8,-11,-3,-5,-7,-8, 0, 2,-1, 10,
	-7,-8,-7,-12,-10,-10,-11,-8,-5,-1,-1,-11,-3, 9,
	 0,-3,-4,-6,-6,-2,-4,-4,-3,-7,-6,-5,-6,-8, 8,
	 0,-2, 1,-2,-2,-4,-3,-1,-4,-5,-7,-3,-4,-5,-1, 6,
	 0,-5,-1,-3,-6,-4,-4,-4,-5,-1,-5,-2,-3,-7,-3, 1, 6,
	-11,-1,-7,-12,-13,-10,-13,-12,-6,-11,-5,-9,-10,-3,-11,-4,-10, 13,
	-6,-8,-3,-9,-3,-9,-7,-11,-2,-5,-5,-8,-8, 3,-11,-5,-5,-4, 9,
	-1,-6,-6,-6,-5,-5,-5,-4,-5, 3,-1,-7, 0,-6,-4,-4,-2,-12,-6, 7,
	-2,-5, 5, 6,-9,-2, 2,-2, 0,-5,-7,-1,-7,-9,-5,-1,-2,-8,-5,-6, 5,
	-2,-2,-1, 2,-11, 6, 6,-4, 0,-5,-5,-2,-4,-11,-3,-3,-4,-11,-8,-5, 1, 6,
	-2,-4,-2,-4,-7,-3,-3,-4,-4,-3,-5,-4,-4,-6,-4,-2,-2,-9,-6,-3,-3,-3,-4,
	-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 500 substitution matrix, scale = ln(2)/7 = 0.0990210
	//
	// Expected score = -0.401, Entropy = 0.0803 bits
	//
	// Lowest score = -9, Highest score = 34
	//
	public final String pam500_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam500 =  { 
	 1,
	-1, 5,
	 0, 1, 1,
	 1, 0, 2, 3,
	-2,-4,-3,-5, 22,
	 0, 2, 1, 2,-5, 2,
	 1, 0, 1, 3,-5, 2, 3,
	 1,-1, 1, 1,-3, 0, 1, 4,
	 0, 2, 1, 1,-4, 2, 1,-1, 4,
	 0,-2,-1,-2,-2,-1,-2,-2,-2, 3,
	-1,-2,-2,-3,-6,-2,-3,-3,-2, 4, 7,
	 0, 4, 1, 1,-5, 1, 1, 0, 1,-2,-2, 4,
	-1, 0,-1,-2,-5,-1,-1,-2,-1, 3, 4, 0, 4,
	-3,-4,-4,-5,-3,-4,-5,-5,-2, 2, 4,-5, 1, 13,
	 1, 0, 0, 0,-2, 1, 0, 1, 0,-1,-2, 0,-1,-4, 4,
	 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-3, 1, 1,
	 1, 0, 0, 0,-2, 0, 0, 1, 0, 0,-1, 0, 0,-3, 1, 1, 1,
	-6, 4,-5,-7,-9,-5,-7,-8,-2,-5,-1,-3,-4, 3,-6,-3,-6, 34,
	-3,-4,-3,-5, 2,-4,-5,-5, 0, 0, 1,-5,-1, 13,-5,-3,-3, 2, 15,
	 0,-2,-1,-1,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-1, 3,
	 1, 0, 1, 2,-4, 2, 2, 1, 1,-2,-3, 1,-1,-4, 0, 1, 0,-6,-4,-1, 2,
	 0, 1, 1, 2,-5, 2, 2, 1, 2,-2,-2, 1,-1,-5, 1, 0, 0,-6,-4,-1, 2, 2,
	 0, 0, 0, 0,-2, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 60 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -3.21, Entropy = 1.79 bits
	//
	// Lowest score = -12, Highest score = 13
	//
	public final String pam60_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam60 =  { 
	 5,
	-5, 8,
	-2,-3, 6,
	-2,-6, 2, 7,
	-5,-6,-7,-10, 9,
	-3, 0,-2,-1,-10, 7,
	-1,-6, 0, 3,-10, 2, 7,
	 0,-7,-1,-2,-7,-5,-2, 6,
	-5, 0, 1,-2,-6, 2,-3,-6, 8,
	-3,-4,-4,-5,-4,-5,-4,-7,-6, 7,
	-4,-6,-5,-9,-11,-3,-7,-8,-4, 0, 6,
	-5, 2, 0,-2,-10,-1,-3,-5,-4,-4,-6, 6,
	-3,-2,-6,-7,-10,-2,-5,-6,-7, 1, 2, 0, 10,
	-6,-7,-6,-11,-9,-9,-10,-7,-4,-1,-1,-10,-2, 8,
	 0,-2,-4,-5,-6,-1,-3,-4,-2,-6,-5,-4,-6,-7, 7,
	 1,-2, 1,-2,-1,-3,-2, 0,-4,-4,-6,-2,-4,-5, 0, 5,
	 1,-4,-1,-3,-5,-4,-4,-3,-5,-1,-5,-2,-2,-6,-2, 1, 6,
	-10, 0,-6,-11,-12,-9,-12,-11,-5,-10,-4,-8,-9,-3,-10,-4,-9, 13,
	-6,-8,-3,-8,-2,-8,-7,-10,-2,-4,-5,-7,-7, 3,-10,-5,-5,-3, 9,
	-1,-5,-5,-6,-4,-5,-4,-4,-5, 3,-1,-6, 0,-5,-4,-4,-1,-11,-5, 6,
	-2,-5, 5, 5,-9,-1, 2,-2, 0,-4,-7,-1,-6,-8,-4, 0,-2,-8,-5,-5, 5,
	-2,-2,-1, 2,-10, 6, 5,-3, 0,-4,-5,-2,-4,-10,-2,-3,-4,-11,-7,-5, 1, 5,
	-2,-4,-2,-3,-6,-3,-3,-3,-3,-3,-4,-3,-3,-5,-3,-2,-2,-8,-5,-3,-3,-3,-3,
	-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 70 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -2.77, Entropy = 1.60 bits
	//
	// Lowest score = -11, Highest score = 13
	//
	public final String pam70_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam70 =  { 
	 5,
	-4, 8,
	-2,-3, 6,
	-1,-6, 3, 6,
	-4,-5,-7,-9, 9,
	-2, 0,-1, 0,-9, 7,
	-1,-5, 0, 3,-9, 2, 6,
	 0,-6,-1,-1,-6,-4,-2, 6,
	-4, 0, 1,-1,-5, 2,-2,-6, 8,
	-2,-3,-3,-5,-4,-5,-4,-6,-6, 7,
	-4,-6,-5,-8,-10,-3,-6,-7,-4, 1, 6,
	-4, 2, 0,-2,-9,-1,-2,-5,-3,-4,-5, 6,
	-3,-2,-5,-7,-9,-2,-4,-6,-6, 1, 2, 0, 10,
	-6,-7,-6,-10,-8,-9,-9,-7,-4, 0,-1,-9,-2, 8,
	 0,-2,-3,-4,-5,-1,-3,-3,-2,-5,-5,-4,-5,-7, 7,
	 1,-1, 1,-1,-1,-3,-2, 0,-3,-4,-6,-2,-3,-4, 0, 5,
	 1,-4, 0,-2,-5,-3,-3,-3,-4,-1,-4,-1,-2,-6,-2, 2, 6,
	-9, 0,-6,-10,-11,-8,-11,-10,-5,-9,-4,-7,-8,-2,-9,-3,-8, 13,
	-5,-7,-3,-7,-2,-8,-6,-9,-1,-4,-4,-7,-7, 4,-9,-5,-4,-3, 9,
	-1,-5,-5,-5,-4,-4,-4,-3,-4, 3, 0,-6, 0,-5,-3,-3,-1,-10,-5, 6,
	-1,-4, 5, 5,-8,-1, 2,-1, 0,-4,-6,-1,-6,-7,-4, 0,-1,-7,-4,-5, 5,
	-1,-2,-1, 2,-9, 5, 5,-3, 1,-4,-4,-2,-3,-9,-2,-2,-3,-10,-7,-4, 1, 5,
	-2,-3,-2,-3,-6,-2,-3,-3,-3,-3,-4,-3,-3,-5,-3,-1,-2,-7,-5,-2,-2,-3,-3,
	-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 80 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -2.55, Entropy = 1.44 bits
	//
	// Lowest score = -11, Highest score = 13
	//
	public final String pam80_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam80 =  { 
	 4,
	-4, 7,
	-1,-2, 5,
	-1,-5, 3, 6,
	-4,-5,-6,-9, 9,
	-2, 0,-1, 0,-9, 7,
	-1,-4, 0, 4,-9, 2, 6,
	 0,-6,-1,-1,-6,-4,-2, 6,
	-4, 0, 2,-1,-5, 2,-2,-5, 8,
	-2,-3,-3,-4,-4,-4,-3,-6,-5, 7,
	-4,-5,-5,-7,-9,-3,-6,-7,-4, 1, 6,
	-4, 2, 0,-2,-9,-1,-2,-4,-3,-4,-5, 6,
	-3,-2,-4,-6,-8,-2,-4,-5,-5, 1, 2, 0, 9,
	-5,-6,-5,-9,-8,-8,-9,-6,-3, 0, 0,-9,-2, 8,
	 0,-2,-3,-4,-5,-1,-3,-3,-2,-5,-4,-4,-5,-7, 7,
	 1,-1, 1,-1,-1,-3,-2, 0,-3,-4,-5,-2,-3,-4, 0, 4,
	 1,-3, 0,-2,-4,-3,-3,-2,-4,-1,-4,-1,-2,-5,-2, 2, 5,
	-8, 0,-5,-10,-10,-8,-11,-10,-4,-8,-3,-7,-7,-2,-9,-3,-8, 13,
	-5,-7,-3,-7,-2,-7,-6,-8,-1,-3,-4,-6,-6, 4,-8,-4,-4,-2, 9,
	 0,-5,-4,-5,-3,-4,-4,-3,-4, 3, 0,-5, 1,-4,-3,-3,-1,-10,-5, 6,
	-1,-3, 4, 5,-7, 0, 2,-1, 0,-4,-6,-1,-5,-7,-3, 0,-1,-7,-4,-4, 5,
	-1,-1, 0, 2,-9, 5, 5,-2, 1,-4,-4,-1,-3,-8,-2,-2,-3,-9,-6,-4, 2, 5,
	-1,-3,-1,-3,-5,-2,-2,-3,-2,-2,-3,-3,-2,-5,-2,-1,-1,-7,-4,-2,-2,-2,-3,
	-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 90 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -2.26, Entropy = 1.30 bits
	//
	// Lowest score = -10, Highest score = 13
	//
	public final String pam90_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam90 =  { 
	 4,
	-4, 7,
	-1,-2, 5,
	-1,-5, 3, 6,
	-3,-5,-6,-8, 9,
	-2, 0,-1, 0,-8, 6,
	 0,-4, 0, 4,-8, 2, 6,
	 0,-5,-1,-1,-5,-3,-1, 5,
	-4, 1, 2,-1,-5, 2,-1,-5, 8,
	-2,-3,-3,-4,-3,-4,-3,-5,-5, 6,
	-3,-5,-4,-7,-9,-3,-5,-6,-3, 1, 6,
	-3, 2, 1,-2,-8,-1,-2,-4,-2,-3,-5, 5,
	-2,-2,-4,-5,-8,-2,-4,-5,-5, 1, 2, 0, 9,
	-5,-6,-5,-8,-7,-7,-8,-6,-3, 0, 0,-8,-1, 8,
	 0,-1,-2,-4,-5,-1,-2,-3,-2,-4,-4,-3,-4,-6, 7,
	 1,-1, 1,-1,-1,-2,-2, 0,-3,-3,-5,-1,-3,-4, 0, 4,
	 1,-3, 0,-2,-4,-3,-2,-2,-3, 0,-3,-1,-2,-5,-1, 2, 5,
	-8, 0,-5,-9,-10,-7,-10,-9,-4,-8,-3,-6,-7,-2,-8,-3,-7, 13,
	-5,-6,-2,-6,-1,-6,-6,-8,-1,-3,-3,-6,-6, 4,-8,-4,-4,-2, 9,
	 0,-4,-4,-4,-3,-4,-3,-3,-4, 3, 0,-5, 1,-4,-3,-3,-1,-9,-4, 6,
	-1,-3, 4, 5,-7, 0, 2,-1, 1,-3,-5, 0,-5,-6,-3, 0,-1,-7,-4,-4, 4,
	-1,-1, 0, 3,-8, 5, 5,-2, 1,-3,-4,-1,-3,-8,-2,-2,-2,-8,-6,-3, 2, 5,
	-1,-2,-1,-2,-5,-2,-2,-2,-2,-2,-3,-2,-2,-4,-2,-1,-1,-6,-4,-2,-2,-2,-2,
	-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
	};
}
