
/*
 * 
 *  file:  ./src/edu/virginia/bioch/util/Counter.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.util;


import java.lang.*;

public class Counter
{
	protected int count;

	public Counter(int x)
	{ count = x; }

	public Counter()
	{ count = 0; }

	public int getCount()
	{ return count; }

	public String toString()
	{ return new String("Count: " + count); }

	public void increment()
	{ count++; }

	public void incrementBy( int c )
	{ count += c; }

	public void decrement()
	{ count--; }

	public void decrementBy( int c )
	{ count -= c; }

	public void setCount( int c )
	{ count = c; }

	public boolean equals( Object c )
	{
		System.out.println("calling counter equals");

		if ( c == this )
			return true;

		if ( c instanceof Counter )
		{
			if ( count == ((Counter)c).getCount() )
				return true;
			else
				return false;
		}
		else
			return false;	

	}
}
