
/*
 * 
 *  file:  ./src/edu/virginia/bioch/util/FastaReader.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.util;

import java.*;
import java.io.*;
import java.net.*;
import java.util.zip.*;

public class FastaReader {

	protected String sequence;
	protected String header;

	public FastaReader( String fileName )
		throws IOException, DataFormatException
	{
		//read( new BufferedReader( new FileReader( fileName ) ) );
		read( GenericReader.getFileReader( fileName ) ); 
	}

	public FastaReader( URL url )
		throws IOException, DataFormatException
	{
		//URLConnection data = (URLConnection)url.openConnection();
		//read(new BufferedReader(new InputStreamReader(data.getInputStream())));
		read( GenericReader.getURLReader( url ) ); 
	}

	private void read( BufferedReader br )
		throws IOException, DataFormatException
	{
		String line = "";
		boolean gotHeader = false;
		StringBuffer seq = new StringBuffer();

		// read header and sequence data
		while ( ( line = br.readLine() ) != null )
		{
			if ( !gotHeader )
			{
				if ( line.charAt(0) == '>' ) 
				{	
					header = line;
					gotHeader = true;
				}
				else
					throw( new DataFormatException(
								"Incorrectly formatted fasta file. " +
								"Missing '>' character." ) );

				continue;
			}
			
			seq.append( line );
		}


		// clean up any erroneous data
		for ( int i = 0; i < seq.length(); i++ )
		{
			if ( !Character.isLetter( seq.charAt( i ) ) )
				seq.deleteCharAt( i );
		}

		sequence = seq.toString();
	}

	public String getHeader()
	{ return header; }

	public String getSequence()
	{ return sequence; }

}
