
/*
 * 
 *  file:  ./src/edu/virginia/bioch/util/GenericReader.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.util;

import java.io.*;
import java.net.*;

public class GenericReader
{
	public static BufferedReader getFileReader( String name )
		throws IOException, FileNotFoundException
	{
		return new BufferedReader( new FileReader( name ) );
	}	

	public static BufferedReader getFileReader( File name )
		throws IOException, FileNotFoundException
	{
		return new BufferedReader( new FileReader( name ) );
	}	

	public static BufferedReader getURLReader( String name )
		throws IOException
	{
		URL url = new URL( name );
		HttpURLConnection data = (HttpURLConnection)url.openConnection();
		return new BufferedReader(new InputStreamReader(data.getInputStream()));
	}

	public static BufferedReader getURLReader( URL url )
		throws IOException
	{
		URLConnection data = (URLConnection)url.openConnection();
		return new BufferedReader(new InputStreamReader(data.getInputStream()));
	}
}
