
/****************************************************************************** 
 * 
 *  file:  Whence.h
 * 
 *  Copyright (c) 2003,  University of Virginia..
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#ifndef WHENCE_H
#define WHENCE_H

#include <string>
#include <vector>
#include <algorithm>
#include <iostream>
#include <GenericException.h>
#include <Tostring.h>

using namespace std;

namespace NOPT {

/**
 * From whence we came.
 * A class used for remembering the direction through the score matrix.
 * This describes how we got to where we are.
 */
class Whence 
{
	/**
	 * Operator <<.
	 * Writes the object to an ostream. Used primarily for debugging.
	 * \param ostream os - The ostream to write to. 
	 * \param Whence w - The Whence object to write.
	 */
	friend ostream& operator<<(ostream& os, const Whence& w);

	public:

		/**
		 * Constructor.
		 * Initializes the object.
		 * \param int bitMask - The direction bitmask. The possible values
		 * are specified in AlignmentGenerator.h.
		 * \param int downIndex - The down index. Defaults to 0.
		 * \param int acrossIndex - The across index. Defaults to 0.
		 */ 
		Whence(int bitMask = 0, int downIndex = 0, int acrossIndex = 0);

		/**
		 * Assignment operator.
		 * Assigns the value of w to this.
		 * \param Whence w - The object to assign to this.
		 */
		Whence& operator=(const Whence& w);

		/**
		 * Operator ==.
		 * Tests whether the objects are equivalent.
		 * \param Whence w - The object to compare with this.
		 */
		bool operator==(const Whence& w);

		/**
		 * Returns the across index.
		 */
		int getAcrossIndex() const;

		/**
		 * Returns the down index.
		 */
		int getDownIndex() const;

		/**
		 * Returns the direction bitmask. 
		 */
		int getDirection() const;

		/**
		 * Sets the direction bitmask.
		 * \param int x - Value to set direction to.
		 */
		void setDirection( int x );

		/**
		 * Sets the down index. 
		 * \param int x - Value to set down index to. 
		 */
		void setDownIndex( int x );

		/**
		 * Sets the across index. 
		 * \param int x - Value to set across index to. 
		 */
		void setAcrossIndex( int x );

	protected:

		/**
		 * Direction bitmask.
		 */
		int _bitMask;

		/**
		 * Down index. 
		 * This is the index that a gap down begins on.
		 */
		int _downIndex;

		/**
		 * Across index.
		 * This is the index that a gap across begins on.
		 */
		int _acrossIndex;
};

}

#endif

