
/****************************************************************************** 
 * 
 *  file:  AltshulGishParams.cpp
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#include "AltshulGishParams.h"

namespace NOPT {

AltshulGishParams::AltshulGishParams( const string& name, int gc, int ge )
:_matrixName(name),
 _gapCreate(gc),
 _gapExtend(ge)
{
	transform( _matrixName.begin(), _matrixName.end(), 
			   _matrixName.begin(), ::tolower );  // no idea why its ::tolower
	                                              // and not std::tolower

	if      ( _matrixName == "blosum50" )
		_create( FASTA::blosum50_p, FASTA::blosum50_size );
	else if ( _matrixName == "blosum55" )
		_create( FASTA::blosum55_p, FASTA::blosum55_size );
	else if ( _matrixName == "blosum62" )
		_create( FASTA::blosum62_p, FASTA::blosum62_size );
	else if ( _matrixName == "blosum80" )
		_create( FASTA::blosum80_p, FASTA::blosum80_size );
	else if ( _matrixName == "pam120" )
		_create( FASTA::pam120_p, FASTA::pam120_size );
	else if ( _matrixName == "pam250" )
		_create( FASTA::pam250_p, FASTA::pam250_size );
	else if ( _matrixName == "md10" )
		_create( FASTA::md10_p, FASTA::md10_size );
	else if ( _matrixName == "md20" )
		_create( FASTA::md20_p, FASTA::md20_size );
	else if ( _matrixName == "md40" )
		_create( FASTA::md40_p, FASTA::md40_size );
	else 
		throw( GenericException("Matrix: " + name + "  not supported!") );

}

void AltshulGishParams::_create(const FASTA::alt_p params[], const int size)
{
	for (int i = 0; i < size; i++ ) 
	{
		if ( -_gapCreate == params[i].gap && -_gapExtend == params[i].ext )
		{
			_K = params[i].K;	
			_H = params[i].H;	
			_Lambda = params[i].Lambda;	
			return;
		}
	}

	throw( GenericException("Matrix/penalty combination not supported!") );
}

}
