
/****************************************************************************** 
 * 
 *  file:  FASTA_ScoringMatrices.h
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 





//===========================================================================
//
// Scoring Matrices delivered with the FASTA package and transformed into
// usable arrays.
//
//===========================================================================

using namespace std;

namespace FASTA {

const char dna_Alphabet[18] = {"ACGTURYMWSKDHVBNX"};
const int dna[162] = {
 /*A*/  5, 
 /*C*/ -4,  5, 
 /*G*/ -4, -4,  5,
 /*T*/ -4, -4, -4,  5,
 /*U*/ -4, -4, -4,  5,  5,
 /*R*/  2, -1,  2, -1, -1,  2,
 /*Y*/ -1,  2, -1,  2,  2, -2,  2,
 /*M*/  2,  2, -1, -1, -1, -1, -1,  2,
 /*W*/  2, -1, -1,  2,  2,  1,  1,  1,  2,
 /*S*/ -1,  2,  2, -1, -1,  1,  1,  1, -1,  2,
 /*K*/ -1, -1,  2,  2,  2,  1,  1, -1,  1,  1,  2,
 /*D*/  1, -2,  1,  1,  1,  1, -1, -1,  1, -1,  1,  1,
 /*H*/  1,  1, -2,  1,  1, -1,  1,  1,  1, -1, -1, -1,  1,
 /*V*/  1,  1,  1, -2, -1,  1, -1,  1, -1,  1, -1, -1, -1,  1,
 /*B*/ -2,  1,  1,  1,  1, -1,  1, -1, -1,  1,  1, -1, -1, -1,  1,
 /*N*/ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
 /*X*/ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

const char dna_simple_Alphabet[18] = {"ACGT"};
const int dna_simple[10] = {
 /*A*/  1, 
 /*C*/ -1,  1, 
 /*G*/ -1, -1,  1,
 /*T*/ -1, -1, -1,  1
};

const char protein_simple_Alphabet[25] = { "ARNDCQEGHILKMFPSTWYVBZX*"};
const int protein_simple[325] =  {
1,
-1,1,
-1,-1,1,
-1,-1,-1,1,
-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1
};


}

