
/****************************************************************************** 
 * 
 *  file:  GenericException.h
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 

/*************************************************************************

CLASS
	GenericException 
	
DESCRIPTION
	A class used for defining exceptions.  

AUTHOR
	Mike Smoot

*************************************************************************/

#ifndef GENERICEXCEPTION_H
#define GENERICEXCEPTION_H

#include <string>

using namespace std;

namespace NOPT {

class GenericException
{
	public:
		
		//----------------------------------------------------------------
		// Constructor. 
		//
		GenericException( const string & text = "undefined exception")
			: _errorText(text) {}; 
		
		//----------------------------------------------------------------
		// Copy Constructor.
		//
		GenericException(const GenericException& e) 
			: _errorText(e._errorText) {};

		//----------------------------------------------------------------
		// Destructor. 
		//
		~GenericException(){};

	
		//----------------------------------------------------------------
		// Operator =
		//
		GenericException& operator=( const GenericException& e )
		{ if ( this != &e ) _errorText = e._errorText;  return *this; };

		//----------------------------------------------------------------
		// Returns the name and error text. 
		//
		string errorData() { return ( _errorText ); };

	private:

		//----------------------------------------------------------------
		// The error text of the exception
		//
		string _errorText;

};

}

#endif

