
/****************************************************************************** 
 * 
 *  file:  ScoringMatrix.cpp
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#include "ScoringMatrix.h"

namespace NOPT {

ScoringMatrix::ScoringMatrix( const string& name )
:_matrixName(name)
{
	transform( _matrixName.begin(), _matrixName.end(), 
			   _matrixName.begin(), ::tolower );  // no idea why its ::tolower
	                                              // and not std::tolower
	
	if      ( _matrixName == "blosum100_50" )
		_createPam( BLAST::blosum100_50, BLAST::blosum100_50_Alphabet );
	else if ( _matrixName == "blosum100" )
		_createPam( BLAST::blosum100, BLAST::blosum100_Alphabet );
	else if ( _matrixName == "blosum30_50" )
		_createPam( BLAST::blosum30_50, BLAST::blosum30_50_Alphabet );
	else if ( _matrixName == "blosum30" )
		_createPam( BLAST::blosum30, BLAST::blosum30_Alphabet );
	else if ( _matrixName == "blosum35_50" )
		_createPam( BLAST::blosum35_50, BLAST::blosum35_50_Alphabet );
	else if ( _matrixName == "blosum35" )
		_createPam( BLAST::blosum35, BLAST::blosum35_Alphabet );
	else if ( _matrixName == "blosum40_50" )
		_createPam( BLAST::blosum40_50, BLAST::blosum40_50_Alphabet );
	else if ( _matrixName == "blosum40" )
		_createPam( BLAST::blosum40, BLAST::blosum40_Alphabet );
	else if ( _matrixName == "blosum45_50" )
		_createPam( BLAST::blosum45_50, BLAST::blosum45_50_Alphabet );
	else if ( _matrixName == "blosum45" )
		_createPam( BLAST::blosum45, BLAST::blosum45_Alphabet );
	else if ( _matrixName == "blosum50_50" )
		_createPam( BLAST::blosum50_50, BLAST::blosum50_50_Alphabet );
	else if ( _matrixName == "blosum50" )
		_createPam( BLAST::blosum50, BLAST::blosum50_Alphabet );
	else if ( _matrixName == "blosum55_50" )
		_createPam( BLAST::blosum55_50, BLAST::blosum55_50_Alphabet );
	else if ( _matrixName == "blosum55" )
		_createPam( BLAST::blosum55, BLAST::blosum55_Alphabet );
	else if ( _matrixName == "blosum60_50" )
		_createPam( BLAST::blosum60_50, BLAST::blosum60_50_Alphabet );
	else if ( _matrixName == "blosum60" )
		_createPam( BLAST::blosum60, BLAST::blosum60_Alphabet );
	else if ( _matrixName == "blosum62_50" )
		_createPam( BLAST::blosum62_50, BLAST::blosum62_50_Alphabet );
	else if ( _matrixName == "blosum62" )
		_createPam( BLAST::blosum62, BLAST::blosum62_Alphabet );
	else if ( _matrixName == "blosum65_50" )
		_createPam( BLAST::blosum65_50, BLAST::blosum65_50_Alphabet );
	else if ( _matrixName == "blosum65" )
		_createPam( BLAST::blosum65, BLAST::blosum65_Alphabet );
	else if ( _matrixName == "blosum70_50" )
		_createPam( BLAST::blosum70_50, BLAST::blosum70_50_Alphabet );
	else if ( _matrixName == "blosum70" )
		_createPam( BLAST::blosum70, BLAST::blosum70_Alphabet );
	else if ( _matrixName == "blosum75_50" )
		_createPam( BLAST::blosum75_50, BLAST::blosum75_50_Alphabet );
	else if ( _matrixName == "blosum75" )
		_createPam( BLAST::blosum75, BLAST::blosum75_Alphabet );
	else if ( _matrixName == "blosum80_50" )
		_createPam( BLAST::blosum80_50, BLAST::blosum80_50_Alphabet );
	else if ( _matrixName == "blosum80" )
		_createPam( BLAST::blosum80, BLAST::blosum80_Alphabet );
	else if ( _matrixName == "blosum85_50" )
		_createPam( BLAST::blosum85_50, BLAST::blosum85_50_Alphabet );
	else if ( _matrixName == "blosum85" )
		_createPam( BLAST::blosum85, BLAST::blosum85_Alphabet );
	else if ( _matrixName == "blosum90_50" )
		_createPam( BLAST::blosum90_50, BLAST::blosum90_50_Alphabet );
	else if ( _matrixName == "blosum90" )
		_createPam( BLAST::blosum90, BLAST::blosum90_Alphabet );
	else if ( _matrixName == "blosumn_50" )
		_createPam( BLAST::blosumn_50, BLAST::blosumn_50_Alphabet );
	else if ( _matrixName == "blosumn" )
		_createPam( BLAST::blosumn, BLAST::blosumn_Alphabet );
	else if ( _matrixName == "dayhoff" )
		_createPam( BLAST::dayhoff, BLAST::dayhoff_Alphabet );
	else if ( _matrixName == "gonnet" )
		_createPam( BLAST::gonnet, BLAST::gonnet_Alphabet );
	else if ( _matrixName == "identity" )
		_createPam( BLAST::identity, BLAST::identity_Alphabet );
	else if ( _matrixName == "match" )
		_createPam( BLAST::match, BLAST::match_Alphabet );
	else if ( _matrixName == "pam10" )
		_createPam( BLAST::pam10, BLAST::pam10_Alphabet );
	else if ( _matrixName == "pam100" )
		_createPam( BLAST::pam100, BLAST::pam100_Alphabet );
	else if ( _matrixName == "pam110" )
		_createPam( BLAST::pam110, BLAST::pam110_Alphabet );
	else if ( _matrixName == "pam120_cdi" )
		_createPam( BLAST::pam120_cdi, BLAST::pam120_cdi_Alphabet );
	else if ( _matrixName == "pam120" )
		_createPam( BLAST::pam120, BLAST::pam120_Alphabet );
	else if ( _matrixName == "pam130" )
		_createPam( BLAST::pam130, BLAST::pam130_Alphabet );
	else if ( _matrixName == "pam140" )
		_createPam( BLAST::pam140, BLAST::pam140_Alphabet );
	else if ( _matrixName == "pam150" )
		_createPam( BLAST::pam150, BLAST::pam150_Alphabet );
	else if ( _matrixName == "pam160_cdi" )
		_createPam( BLAST::pam160_cdi, BLAST::pam160_cdi_Alphabet );
	else if ( _matrixName == "pam160" )
		_createPam( BLAST::pam160, BLAST::pam160_Alphabet );
	else if ( _matrixName == "pam170" )
		_createPam( BLAST::pam170, BLAST::pam170_Alphabet );
	else if ( _matrixName == "pam180" )
		_createPam( BLAST::pam180, BLAST::pam180_Alphabet );
	else if ( _matrixName == "pam190" )
		_createPam( BLAST::pam190, BLAST::pam190_Alphabet );
	else if ( _matrixName == "pam20" )
		_createPam( BLAST::pam20, BLAST::pam20_Alphabet );
	else if ( _matrixName == "pam200_cdi" )
		_createPam( BLAST::pam200_cdi, BLAST::pam200_cdi_Alphabet );
	else if ( _matrixName == "pam200" )
		_createPam( BLAST::pam200, BLAST::pam200_Alphabet );
	else if ( _matrixName == "pam210" )
		_createPam( BLAST::pam210, BLAST::pam210_Alphabet );
	else if ( _matrixName == "pam220" )
		_createPam( BLAST::pam220, BLAST::pam220_Alphabet );
	else if ( _matrixName == "pam230" )
		_createPam( BLAST::pam230, BLAST::pam230_Alphabet );
	else if ( _matrixName == "pam240" )
		_createPam( BLAST::pam240, BLAST::pam240_Alphabet );
	else if ( _matrixName == "pam250_cdi" )
		_createPam( BLAST::pam250_cdi, BLAST::pam250_cdi_Alphabet );
	else if ( _matrixName == "pam250" )
		_createPam( BLAST::pam250, BLAST::pam250_Alphabet );
	else if ( _matrixName == "pam260" )
		_createPam( BLAST::pam260, BLAST::pam260_Alphabet );
	else if ( _matrixName == "pam270" )
		_createPam( BLAST::pam270, BLAST::pam270_Alphabet );
	else if ( _matrixName == "pam280" )
		_createPam( BLAST::pam280, BLAST::pam280_Alphabet );
	else if ( _matrixName == "pam290" )
		_createPam( BLAST::pam290, BLAST::pam290_Alphabet );
	else if ( _matrixName == "pam30" )
		_createPam( BLAST::pam30, BLAST::pam30_Alphabet );
	else if ( _matrixName == "pam300" )
		_createPam( BLAST::pam300, BLAST::pam300_Alphabet );
	else if ( _matrixName == "pam310" )
		_createPam( BLAST::pam310, BLAST::pam310_Alphabet );
	else if ( _matrixName == "pam320" )
		_createPam( BLAST::pam320, BLAST::pam320_Alphabet );
	else if ( _matrixName == "pam330" )
		_createPam( BLAST::pam330, BLAST::pam330_Alphabet );
	else if ( _matrixName == "pam340" )
		_createPam( BLAST::pam340, BLAST::pam340_Alphabet );
	else if ( _matrixName == "pam350" )
		_createPam( BLAST::pam350, BLAST::pam350_Alphabet );
	else if ( _matrixName == "pam360" )
		_createPam( BLAST::pam360, BLAST::pam360_Alphabet );
	else if ( _matrixName == "pam370" )
		_createPam( BLAST::pam370, BLAST::pam370_Alphabet );
	else if ( _matrixName == "pam380" )
		_createPam( BLAST::pam380, BLAST::pam380_Alphabet );
	else if ( _matrixName == "pam390" )
		_createPam( BLAST::pam390, BLAST::pam390_Alphabet );
	else if ( _matrixName == "pam40_cdi" )
		_createPam( BLAST::pam40_cdi, BLAST::pam40_cdi_Alphabet );
	else if ( _matrixName == "pam40" )
		_createPam( BLAST::pam40, BLAST::pam40_Alphabet );
	else if ( _matrixName == "pam400" )
		_createPam( BLAST::pam400, BLAST::pam400_Alphabet );
	else if ( _matrixName == "pam410" )
		_createPam( BLAST::pam410, BLAST::pam410_Alphabet );
	else if ( _matrixName == "pam420" )
		_createPam( BLAST::pam420, BLAST::pam420_Alphabet );
	else if ( _matrixName == "pam430" )
		_createPam( BLAST::pam430, BLAST::pam430_Alphabet );
	else if ( _matrixName == "pam440" )
		_createPam( BLAST::pam440, BLAST::pam440_Alphabet );
	else if ( _matrixName == "pam450" )
		_createPam( BLAST::pam450, BLAST::pam450_Alphabet );
	else if ( _matrixName == "pam460" )
		_createPam( BLAST::pam460, BLAST::pam460_Alphabet );
	else if ( _matrixName == "pam470" )
		_createPam( BLAST::pam470, BLAST::pam470_Alphabet );
	else if ( _matrixName == "pam480" )
		_createPam( BLAST::pam480, BLAST::pam480_Alphabet );
	else if ( _matrixName == "pam490" )
		_createPam( BLAST::pam490, BLAST::pam490_Alphabet );
	else if ( _matrixName == "pam50" )
		_createPam( BLAST::pam50, BLAST::pam50_Alphabet );
	else if ( _matrixName == "pam500" )
		_createPam( BLAST::pam500, BLAST::pam500_Alphabet );
	else if ( _matrixName == "pam60" )
		_createPam( BLAST::pam60, BLAST::pam60_Alphabet );
	else if ( _matrixName == "pam70" )
		_createPam( BLAST::pam70, BLAST::pam70_Alphabet );
	else if ( _matrixName == "pam80_cdi" )
		_createPam( BLAST::pam80_cdi, BLAST::pam80_cdi_Alphabet );
	else if ( _matrixName == "pam80" )
		_createPam( BLAST::pam80, BLAST::pam80_Alphabet );
	else if ( _matrixName == "pam90" )
		_createPam( BLAST::pam90, BLAST::pam90_Alphabet );
	else if ( _matrixName == "dna" )
		_createPam( FASTA::dna, FASTA::dna_Alphabet );
	else if ( _matrixName == "dna_simple" )
		_createPam( FASTA::dna_simple, FASTA::dna_simple_Alphabet );
	else if ( _matrixName == "protein_simple" )
		_createPam( FASTA::protein_simple, FASTA::protein_simple_Alphabet );
	else if ( _matrixName == "oldpam250" )
		_createPam( BLAST::oldpam250, BLAST::oldpam250_Alphabet );
	else 
		throw( GenericException("bad matrix name: " + name ) );

	if ( _alphabet.find_first_of('*') == _alphabet.npos )
		_defaultChar = false;
	else
		_defaultChar = true;
	
}

ScoringMatrix::ScoringMatrix(const ScoringMatrix& s)
: 
  _pam(s._pam),
  _matrixName(s._matrixName),
  _alphabet(s._alphabet)
{}

ScoringMatrix& ScoringMatrix::operator=(const ScoringMatrix& s)
{
	if ( this != &s )
	{
		_alphabet = s._alphabet;
		_matrixName = s._matrixName;
		_pam = s._pam;
		_defaultChar = s._defaultChar;
	}

	return *this;
}


int ScoringMatrix::score(char a, char b)
{
	char A = toupper(a);
	char B = toupper(b);

	if ( _alphabet.find_first_of(A) == _alphabet.npos )
		if ( ! _defaultChar )	
			throw(GenericException("Invalid character (as int): " + 
									tos((int)a) ));
		else
		{
			cerr << "Invalid character (as int): " + 
					tos((int)a) + " using *" << endl;
			A = '*';
		}

	if ( _alphabet.find_first_of(B) == _alphabet.npos )
		if ( ! _defaultChar )	
			throw(GenericException("Invalid character (as int): " 
									+ tos((int)b) ));
		else
		{
			cerr << "Invalid character (as int): " + 
					tos((int)b) + " using *" << endl;
			B = '*';
		}
	
	return _pam[A][B];
}

void ScoringMatrix::_createPam(const int* pam, const char* al)
{
	_alphabet = al;

	int k = 0;
	for (int i = 0; (unsigned int)i < _alphabet.length(); i++)
		for (int j = 0; j <= i; j++)
			_pam[ _alphabet[i] ][ _alphabet[j] ] =
			_pam[ _alphabet[j] ][ _alphabet[i] ] = pam[k++];
	
}

}
