
/****************************************************************************** 
 * 
 *  file:  Tostring.h
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 

/***************************************************************************

DESCRIPTION
	Some template functions that translate different types to strings.
	Useful for creating error messages and the like.

AUTHOR
	Mike Smoot

***************************************************************************/

#ifndef TOSTRING_H
#define TOSTRING_H

#include <config.h>
#include <string>
#include <iomanip>

#if HAVE_SSTREAM
#include <sstream>
#elif HAVE_STRSTREAM
#include <strstream>
#else 
#error Need a string stream library! 
#endif

using namespace std;

namespace NOPT {

//-----------------------------------------------------------------------
// ztos - zero padded T to string - useful for ints, floats, etc.
//
template <class T>
string ztos(const T& t, const int& numDigits, const int& num=0 )
{

#if HAVE_SSTREAM
	ostringstream os;
#elif HAVE_STRSTREAM
	strstream os;
#endif

	if ( num != 0 )
		os << setprecision(num);

	os << setiosflags(ios::showpoint|ios::fixed)
	   << t; 
	   //<< ends;
	string s(os.str());
	//os.rdbuf()->freeze(0);

	while (s.length() < (unsigned)numDigits)
		s = "0" + s; 

	return s;
}



/*
**
**  Copyright (C) 2000 Gustavo Niemeyer
**
**  http://projects.nn.com.br/
**
*/
//-----------------------------------------------------------------------
// Type T to string. 
//
// Originally from Gustavo Niemeyer but modified by me.
// This code was found on sourceforge.net in the C++ snippets section.
//
template<class T>
string tos(const T& t, const int& num=0)
{

#if HAVE_SSTREAM
	ostringstream os;
#elif HAVE_STRSTREAM
	strstream os;
#endif

	if ( num != 0 )
		os << setprecision(num);
	
	os << setiosflags(ios::showpoint|ios::fixed)
	   << t ;
	   //<< ends;
	string s(os.str());
	//os.rdbuf()->freeze(0);
	return s;
}


}

#endif



