
/****************************************************************************** 
 * 
 *  file:  XML.cpp
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#include "XML.h"

namespace NOPT {

//-------------------------------------------------------------------------
// Will encapsulate data within tags.
//-------------------------------------------------------------------------
string XML::tag( const string& tagName, const string& data )
{
	string s = "<" + tagName + ">" + data + "</" + tagName + ">\n";
	return s;
}

//-------------------------------------------------------------------------
// Will encapsulate data within tags and add specified attributes
// to the tag.
//-------------------------------------------------------------------------
string XML::tag( const string& tagName, 
				 const string& data,
				 const map<string,string>& attributes )
{
	string s = "<" + tagName ; 

	map<string,string>::const_iterator MI;

	for ( MI = attributes.begin(); MI != attributes.end(); MI++ )
		s += " " + MI->first + "=\"" + MI->second + "\"";
	
	s += ">" + data + "</" + tagName + ">\n";

	return s;
}

}
