
/****************************************************************************** 
 * 
 *  file:  XML.h
 * 
 *  Copyright (c) 2003,  University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 *****************************************************************************/ 


#ifndef MY_XML_H
#define MY_XML_H

#include <string>
#include <vector>
#include <map>

using namespace std;

namespace NOPT {

class XML 
{
	public:
		static string tag(const string& tag, const string& data);
		static string tag(const string& tag, 
						  const string& data,
						  const map<string,string>& attributes);
		template<class T> static string tag( const string& tagName,
				                             const vector<T>& data )
		{
			string s = "";
			for ( int i = 0; (unsigned int)i < data.size(); i++ )
			{
				s += tag( tagName, data[i].getXml() );
			}

			return s;
		};

};

}

#endif

