
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/Coverage.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt;


import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;
import java.io.IOException;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.display.path.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.util.*;

import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;

public class Coverage extends JFrame
{
	protected PathDisplay sc;

	public static void main( String[] args ) 
    {

		System.out.println("Coverage main");

		try {
				UIManager
						.setLookAndFeel(UIManager
						.getCrossPlatformLookAndFeelClassName());
		} catch (Exception e) {
				e.printStackTrace();
				System.exit(1);
		}

		//Create the top-level container and add contents to it.
		try {
			JFrame frame = new Coverage(args);
			frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			frame.pack();
			frame.setVisible(true);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public Coverage( String[] args )
	{
		System.out.println("Coverage constructor");

		setBackground( Color.white );

		try {

		FastaReader fr1 = new FastaReader( args[0] );
		FastaReader fr2 = new FastaReader( args[1] );
		EdgeReader er = new EdgeReader( args[2], args[3], 
		                                fr1.getSequence(), 
										fr2.getSequence() );

		sc = new PathDisplay( er );

		getContentPane().add( sc );

		} catch (Exception e) { e.printStackTrace(); System.exit(1); }
	}
}	
