
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/EdgeReader.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;
import java.io.IOException;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.scoringmatrices.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.util.regex.*;
import java.io.*;

public class EdgeReader
	implements EdgeContainer
{

	protected HashMap edgeMap;
	protected Vector edgeList;
	protected String seq1;
	protected String seq2;

	public EdgeReader( String name1, String name2, String seq1, String seq2 )
	{
		System.out.println("EdgeReader constructor");

		this.seq1 = seq1;
		this.seq2 = seq2;

		edgeMap = new HashMap();
		edgeList = new Vector();

		try { 

		BufferedReader input1 = new BufferedReader( new FileReader(name1) );
		BufferedReader input2 = new BufferedReader( new FileReader(name2) );
	

		// read first count file
		String tmp;
		Pattern pat = Pattern.compile(
				   "^[\\w-].\\d+.\\d+.[\\w-].\\d+.\\d+\\s+\\d+$" );
		while ( ( tmp = input1.readLine() ) != null )
		{
			if ( pat.matcher( tmp ).find() )
			{
				StringTokenizer st = new StringTokenizer(tmp," ");
				EdgeKey key = new EdgeKey( st.nextToken() );
				Integer value = new Integer( st.nextToken() );
				edgeMap.put( key, value );
			}
			else
				continue;
		}

		// read second count file
		while ( ( tmp = input2.readLine() ) != null )
		{
			if ( pat.matcher( tmp ).find() )
			{
				StringTokenizer st = new StringTokenizer(tmp," ");
				EdgeKey key = new EdgeKey( st.nextToken() );
				Integer value = new Integer( st.nextToken() );
				edgeList.add( key );
			}
			else
				continue;
		}

		} catch (Exception  e) 
		{ 
			e.printStackTrace(); 
			System.err.println("ERROR: Failed to read one or more files.");
			System.err.println("       Cannot continue.  Exiting.");
			System.exit(1); 
		}

	}

	public Set getAllEdges() { return edgeMap.keySet(); }
	public Vector getCurrentEdges() { return edgeList; }
	public String getSeq1() { return seq1; }
	public String getSeq2() { return seq2; }
}      

