
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/SeqCompare.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt;


import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;
import java.io.IOException;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.display.path.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.actions.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.scoringmatrices.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;

public class SeqCompare 
{
	protected Component parent;
	protected SeqComparePanel sp;
	protected AlignmentHandler ah;
	protected OptionTableModel otm;

	public SeqCompare( Component p, BufferedReader aln, BufferedReader feat, 
			           String exContext, AddOptionSetAction aos )
		throws Exception
	{
		System.out.println("SeqCompare constructor");

		parent = p;

		// read alignments
		AlignmentSetReader ar = new AlignmentSetReader( aln );
		ah = new AlignmentHandler( ar );

		FontHandler fh = new FontHandler( new JPanel() );

		// set up options
		Option.setFonts( fh );
		OptionHandler oh = new OptionHandler( ah );


		// read options

		OptionSetReader oc = null; 
		Map optionMap = new HashMap();

		try { 

		oc = new OptionSetReader( feat ); 
		optionMap = oc.getOptionMap();

		} catch (Exception e )
		{
			JOptionPane.showMessageDialog( p, e.getMessage(), 
					                       "Ignoring error.", 
										   JOptionPane.ERROR_MESSAGE );
		}
		
		otm = new OptionTableModel( ah, optionMap ); 
		OptionSelectionPanel osp = new OptionSelectionPanel(oh, otm, ah,
															exContext, aos);


		ConditionHandler ch = new ConditionHandler( ah );
		ConditionSelectionPanel csp = new ConditionSelectionPanel( ch, 
				                                              new HashMap() );

		sp = new SeqComparePanel(oh,fh,ch,ah,osp,csp,parent);

		Container contentPane = ((RootPaneContainer)parent).getContentPane();
		contentPane.removeAll();
		contentPane.setBackground( Color.white );
		contentPane.add(sp);
		contentPane.validate(); // necessary
		contentPane.repaint();
	}

	public AlignmentHandler getAlignmentHandler()
	{ return ah; }

	public SeqComparePanel getSeqComparePanel()
	{ return sp; }

	public OptionTableModel getOptionTableModel()
	{ return otm; }

}      

