
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/SeqCompareApplet.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt;



import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;
import java.io.IOException;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.display.path.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;

import edu.virginia.bioch.util.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;

public class SeqCompareApplet extends JApplet 
{
	public SeqCompareApplet()
	{
		System.out.println("SeqCompareApplet constructor");
		getRootPane().putClientProperty("defeatSystemEventQueueCheck",                                        Boolean.TRUE);
	}

	public void init()
	{
		System.out.println("SeqCompareApplet init");


		try {

		String alignmentURL = getParameter("alignmentURL");
		String featureURL = getParameter("featureURL");
		
		SeqCompare sc = new SeqCompare( this,
			                       GenericReader.getURLReader( alignmentURL ),
			                       GenericReader.getURLReader( featureURL ),
								   "applet", null );

		} catch ( Exception e ) 
		{
			e.printStackTrace();
			showStatus("FAILURE: " + e.getMessage() );
		}
	}
}
