
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/actions/EditSelectionAction.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.actions;


import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.display.path.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.*;
import edu.virginia.bioch.scoringmatrices.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;

public class EditSelectionAction
	extends AbstractAction
{
	protected Component com;
	protected Reinitializable opt;
	protected SelectionPanel sel;
	protected String title;
	
	public EditSelectionAction( Component c, 
			                    Reinitializable o, 
								SelectionPanel s,
			                    String t )
	{ 
		super(t);
		com = c;
		opt = o;
		sel = s;
		title = t;
	}

	public void actionPerformed( ActionEvent e )
	{
		sel.prepareSelections();
		
		boolean success = false;

		do {
		int ret = JOptionPane.showConfirmDialog( com, sel, title, 
												 JOptionPane.OK_CANCEL_OPTION,
							 					 JOptionPane.PLAIN_MESSAGE );

		if ( ret == JOptionPane.YES_OPTION )
		{
			success = sel.processSelections();
			opt.reinitialize();
			com.repaint();
		}
		else
			success = true;

		} while ( !success ); 
	}
}
