
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/actions/SaveAlignmentSetAction.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.actions;


import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;
import java.io.IOException;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.display.path.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.*;
import edu.virginia.bioch.scoringmatrices.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;
import java.beans.*;

public class SaveAlignmentSetAction
	extends AbstractAction
	implements PropertyChangeListener
{
	protected JFileChooser fc;
	protected Component frame;
	protected AlignmentHandler ah;
	
	public SaveAlignmentSetAction( Component f )//, AlignmentHandler ah )
	{ 
		super("Save Alignment Set");
		fc = new JFileChooser();
		frame = f;
		ah = null;	
		setEnabled( false );
	}

    public void propertyChange(PropertyChangeEvent e)
    {
        if ( e.getPropertyName().equals( "setSeqCompare" ) )
        {
            SeqCompare sc = (SeqCompare)e.getNewValue();
            ah = sc.getAlignmentHandler();
            setEnabled( true );
        }
    }

	public void actionPerformed( ActionEvent e )
	{
		SwingUtilities.invokeLater( new Runnable() { public void run() {

		if (fc.showSaveDialog( frame ) == JFileChooser.APPROVE_OPTION)
		{
			try {

        	FileWriter fw = new FileWriter( fc.getSelectedFile() );

			AlignmentSetReader asr = ah.getAlignmentSetReader();

			writeVector( fw, "p", asr.getParameters() );
			writeVector( fw, "a", asr.getAlignments() );
			writeVector( fw, "r", asr.getRobust() );

        	fw.close();

        	} catch ( IOException ex )
        	{
            	ex.printStackTrace();
            	String message = "Couldn't save Alignment set file.";
            	String trace = "ERROR: \"" + ex.getMessage() + "\"";

            	Object[] array = {message,trace};

            	JOptionPane.showMessageDialog(frame, array);
        	}
		}

		}} );
	}

	private void writeVector( FileWriter fw, String key, Vector v )
		throws IOException
	{
		for ( int i = 0; i < v.size(); i++ )
			fw.write( key + "~" + (String)(v.get(i)) + "\n" );
	}
}
