
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/actions/SaveOptionSetAction.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 



package edu.virginia.bioch.nopt.actions;


import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;
import java.io.IOException;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.display.path.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.*;
import edu.virginia.bioch.scoringmatrices.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;
import java.beans.*;

public class SaveOptionSetAction
	extends AbstractAction
	implements PropertyChangeListener
{
	protected JFileChooser fc;
	protected Component com;
	protected OptionTableModel otm;
	
	public SaveOptionSetAction( Component f )
	{ 
		super("Save Annotation Set");
		fc = new JFileChooser();
		com = f;
		otm = null;	
		setEnabled( false );
	}

    public void propertyChange(PropertyChangeEvent e)
    {
        if ( e.getPropertyName().equals( "setSeqCompare" ) )
        {
            otm = ((SeqCompare)e.getNewValue()).getOptionTableModel();
            setEnabled( true );
        }
    }

	public void actionPerformed( ActionEvent e )
	{
		SwingUtilities.invokeLater( new Runnable() { public void run() {

		if (fc.showSaveDialog( com ) == JFileChooser.APPROVE_OPTION)
		{
			try {

        	FileWriter fw = new FileWriter( fc.getSelectedFile() );

			fw.write("# this GFF file is generated by noptalign.jar\n");

			Map opts = otm.getOptions();
			Iterator it = opts.keySet().iterator();
	        while ( it.hasNext() )
	        {
	            OptionKey key = (OptionKey)(it.next());
				java.util.List ranges = 
								Range.parseRanges( (String)(opts.get( key )));

				Iterator itt = ranges.iterator();
				while ( itt.hasNext() )
				{
					Range r = (Range)(itt.next());
					fw.write( key.getGFFSeqName() + "\t" +
						      key.getGFFSource() + "\t" +
						      key.getGFFFeature() + "\t" +
							  Integer.toString( r.getBegin() ) + "\t" +
							  Integer.toString( r.getEnd() ) + "\t" +
							  ".\t.\t.\n" );
				}
	        }

        	fw.close();

        	} catch ( IOException ex )
        	{
            	ex.printStackTrace();
            	JOptionPane.showMessageDialog(com, 
					 			"Couldn't save Alignment set file.\n" + 
					 			ex.getMessage(),
					 			"ERROR Saving file.",
					 			JOptionPane.ERROR_MESSAGE ); 
        	}
		}

		}} );
	}
}
