
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/actions/SaveTextAlignmentAction.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.actions;


import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;
import java.io.IOException;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.display.path.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.*;
import edu.virginia.bioch.scoringmatrices.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;
import java.beans.*;

public class SaveTextAlignmentAction
	extends AbstractAction
	implements PropertyChangeListener
{
	protected JFileChooser fc;
	protected Component frame;
	protected AlignmentHandler ah;
	
	public SaveTextAlignmentAction( Component f ) //, AlignmentHandler ah )
	{ 
		super("Save Current Alignment As Text");
		fc = new JFileChooser();
		frame = f;
		ah = null;	
		setEnabled( false );
	}

	public void propertyChange(PropertyChangeEvent e)
	{
		if ( e.getPropertyName().equals( "setSeqCompare" ) )
		{
			SeqCompare sc = (SeqCompare)e.getNewValue();
			ah = sc.getAlignmentHandler();
			setEnabled( true );
		}
	}

	public void actionPerformed( ActionEvent e )
	{
		SwingUtilities.invokeLater( new Runnable() { public void run() {

		if (fc.showSaveDialog( frame ) == JFileChooser.APPROVE_OPTION)
		{
        	Alignment sa = ah.getCurrentAlignment();
			AlignmentParameters ap = sa.getAlignmentParameters();
        	StringBuffer seq1 = new StringBuffer( sa.getSeq1() );
        	StringBuffer seq2 = new StringBuffer( sa.getSeq2() );

        	try {

            	FileWriter fw = new FileWriter( fc.getSelectedFile() );

				int limit = 10;

				String n1 = ah.getSeq1Name();
				StringBuffer seq1Name = new StringBuffer( 
						n1.substring(0, Math.min(n1.length(),limit) ) );

				String n2 = ah.getSeq2Name();
				StringBuffer seq2Name = new StringBuffer( 
						 n2.substring(0, Math.min(n2.length(),limit) ) );

				while ( seq1Name.length() < limit ) 
					seq1Name.append(' ');

				while ( seq2Name.length() < limit ) 
					seq2Name.append(' ');

				fw.write(n1 + " (" + ah.getSeq1Description() + ")\n");
				fw.write(" aligned with: \n");
				fw.write(n2 + " (" + ah.getSeq2Description() + ")\n");
				fw.write(" using  " + ap.getScoringMatrixName() +
						 " and " + ap.getGapCreate() +
						 "/" + ap.getGapExtend() + " (open/extend)\n");
				fw.write(" % identity:      " 
						  + sa.getPercentIdentity() + "\n");
				fw.write(" % similarity:    " 
						  + sa.getPercentSimilarity() + "\n");
				fw.write(" alignment score: " 
						  + sa.getScore() + "\n");
				fw.write(" optimal score:   " 
						  + ap.getOptimalScore() + "\n");
				fw.write(" set index:       " 
						  + ah.getCurrentIndex() + "\n\n");

            	while ( seq1.length() > 0 )
            	{
                	int end = 60;
                	if ( seq1.length() < end )
                    	end = seq1.length();

                	String s1 = seq1.substring(0,end);
                	String s2 = seq2.substring(0,end);

                	seq1.delete(0,end);
                	seq2.delete(0,end);

                	fw.write( seq1Name.toString() + "   " + s1 + "\n" );
                	fw.write( seq2Name.toString() + "   " + s2 + "\n\n" );
            	}
            	fw.close();

        	} catch ( IOException ex )
        	{
            	ex.printStackTrace();
            	String message = "Couldn't save this Alignment.";
            	String trace = "ERROR: \"" + ex.getMessage() + "\"";

            	Object[] array = {message,trace};
            	JOptionPane.showMessageDialog(frame, array);
        	}
		}

		}});
	}
}
