
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/actions/StartNewAction.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.actions;


import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.display.path.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.*;
import edu.virginia.bioch.scoringmatrices.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;
import java.beans.*;

public class StartNewAction
	extends AbstractAction
{
	protected Component com;
	protected String context;
	protected SeqCompare sc;
	protected JFileChooser afc;
	protected BufferedReader alignmentSet;
	protected BufferedReader gffSet;
	protected AddOptionSetAction aos;
	
	public StartNewAction( Component c, BufferedReader as, 
			               BufferedReader gs, String con,
						   AddOptionSetAction aos ) 
	{ 
		super("Load New Alignment Set");
		com = c;
		context = con;

		alignmentSet = as;
		gffSet = gs;
		this.aos = aos;

		afc = new JFileChooser();

		sc = null;

		if ( alignmentSet != null )
			create();
		else
			createNull();

	}


	public void actionPerformed( ActionEvent e )
	{
		alignmentSet = null;
		gffSet = null;

		afc.setDialogTitle("Load an alignment set file");
		afc.setApproveButtonText("Load Alignment Set");
		if ( afc.showOpenDialog( com ) == JFileChooser.APPROVE_OPTION )
			try {

			alignmentSet = GenericReader.getFileReader( afc.getSelectedFile() );

			} catch (Exception ex) 
			{ 
				ex.printStackTrace();
				JOptionPane.showMessageDialog(com,
						"Failed to read alignment set: " + 
						ex.getMessage(),
						"FAILURE!",
						JOptionPane.ERROR_MESSAGE );
			}
		else
			return;

		create();
	}

	private void create()
	{
		sc = null;
		try { 

		sc = new SeqCompare( com, alignmentSet, gffSet, context, aos );
		updateProperties();

		} catch ( Exception e )
		{
			e.printStackTrace();
			JOptionPane.showMessageDialog(com,
						"Failed to create SeqCompare object: " + 
						e.getMessage(),
						"FAILURE!",
						JOptionPane.ERROR_MESSAGE );
			createNull();
		}
	}

	private void createNull()
	{
		JPanel nullPanel = new JPanel();
		nullPanel.setPreferredSize( new Dimension( 800, 550 ) );
		Container c = ((RootPaneContainer)com).getContentPane();
		c.add( nullPanel );
		c.validate();
		c.repaint();
	}

	// A wrapper that fires a property change event.  Kind of kludgy.
	public void updateProperties()
	{
		if ( sc != null )
			firePropertyChange( "setSeqCompare", null, sc );
	}
}
