
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/conditions/ConditionHandler.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.conditions;


import java.lang.*;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import javax.swing.event.*;
import javax.swing.*;
import java.beans.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.conditions.*;
import edu.virginia.bioch.nopt.conditions.types.*;
import edu.virginia.bioch.util.*;


public class ConditionHandler extends Component
	implements PropertyChangeListener
{

	protected Vector conditionList;
	protected Vector selectedList;
	protected AlignmentHandler ah;

	public ConditionHandler(AlignmentHandler ah)
	{
		this.ah = ah;
		conditionList = new Vector();
		selectedList = new Vector();

	}

	public void addCondition( Condition c )
		throws Exception
	{
		Vector alignments = ah.getAlignments();
		Iterator it = alignments.iterator();
		boolean atLeastOneValid = false;
		while ( it.hasNext() )
			if ( c.addAlignment( (Alignment)it.next() ) )
				atLeastOneValid = true;

		if ( atLeastOneValid )
			conditionList.add( c );
		else
			throw new Exception("As specified no alignments matched " +
						          " this Filter.");
	}

	public boolean conditionsMet( int i )
	{
		Iterator it = conditionList.iterator();
		while ( it.hasNext() )
		{
			Condition c = (Condition)it.next();
			if ( !c.conditionMet( i ) )
				return false;
		}
		return true;
	}

	public Vector getSelectedConditions()
	{ 
		Vector selected = new Vector();
		Iterator it = conditionList.iterator();
		while ( it.hasNext() )
		{
			Condition c = (Condition)it.next();
			if ( c.isSelected() )
				selected.add( c );
		}
		
		return selected; 
	}

	public void markSelected( int i, boolean b )
	{
		if ( i >= 0 && i < conditionList.size() )
			((Condition)conditionList.get( i )).setSelected( b );
		else
			System.err.println("ConditionHandler  Trying to mark as selected "
					           + "a Condition out of range: "  + i  
							   + ".  Ignoring." );
	}

	public int getNumConditions()
	{ return conditionList.size(); }

	// simply passes the event through
	public void propertyChange(PropertyChangeEvent e)
	{
		firePropertyChange(e.getPropertyName(),null,e.getNewValue());
	}

}
