
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/conditions/types/MatchCondition.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.conditions.types;



import java.lang.*;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import javax.swing.event.*;
import javax.swing.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;


public class MatchCondition extends Condition
{

	protected String rangeString1;
	protected String rangeString2;
	protected Range seq1Range;
	protected Range seq2Range;

	public static String getTypeId( )
	{ return "Match Filter"; }

	public MatchCondition( String n, String d, Range r1, Range r2 )
		throws Exception
	{
		super( MatchCondition.getTypeId(), n, d );
		System.out.println("MatchCondition constructor");
		seq1Range = r1;
		seq2Range = r2;

		sanityCheck();
	}

	private void sanityCheck()
		throws Exception
	{
		if ( !seq1Range.sameLength( seq2Range ) )
			throw( new Exception("Ranges aren't the same length."));
	}

	//
	// This is where the actual condition is applied...
	//
	public boolean addAlignment( Alignment a )
	{
		Vector edges = a.getEdges();
	
		boolean meets = false;

		Iterator it = edges.iterator();
		int meetCount = 0;
		int meetLength = seq1Range.getLength();
		while ( it.hasNext() )
		{
			EdgeKey key = (EdgeKey)it.next();

			int x = key.getEndX();
			int y = key.getEndY();


			char char1 = key.getTopChar();
			char char2 = key.getBotChar();

			if ( seq1Range.inRange( x ) && 
				 seq2Range.inRange( y ) &&
				 char1 != '-' &&
				 char2 != '-' )
				meetCount++;	

			if ( meetCount == meetLength )
			{
				meets = true;
				break;
			}
		}

		System.out.println( "   MatchCondition " + _name + " is " + meets ); 
		_meetsCondition.add( new Boolean( meets ) );

		return meets;
	}
}
