
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/conditions/types/ScoreConditionCreatorPanel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.conditions.types;



import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.lang.Thread.*;
import java.util.*;
import java.lang.Exception.*;
import java.io.IOException;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.conditions.*;

import edu.virginia.bioch.util.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;

public class ScoreConditionCreatorPanel extends JPanel
	implements ConditionCreator, ActionListener
{
	protected JTextField nameText; 
	protected JTextField beginText;
	protected JTextField endText;
	protected JTextField begin2Text;
	protected JTextField end2Text;
	protected JButton addButton;

	public ScoreConditionCreatorPanel( )
	{
		setBackground( Color.white );
		setLayout( new BoxLayout( this, BoxLayout.Y_AXIS ) );
		
		JPanel boxes = new JPanel(); // FlowLayout
		boxes.setBackground( Color.white );

		JLabel nameLabel = new JLabel("Name");
		nameText = new JTextField(40); 
		JPanel namePanel = new JPanel();
		namePanel.add( nameLabel );
		namePanel.add( nameText );
		namePanel.setLayout( new BoxLayout( namePanel, BoxLayout.Y_AXIS ) );
		namePanel.setBackground( Color.white );
		boxes.add( namePanel );


		JLabel spaceLabel = new JLabel("   ");
		boxes.add( spaceLabel );

		JPanel s1Panel = new JPanel();
		s1Panel.setBackground( Color.white );

		JLabel beginLabel = new JLabel("Lower Bound");
		beginText = new JTextField(3); 
		JPanel beginPanel = new JPanel();
		beginPanel.add( beginLabel );
		beginPanel.add( beginText );
		beginPanel.setLayout( new BoxLayout( beginPanel, BoxLayout.Y_AXIS ) );
		beginPanel.setBackground( Color.white );
		s1Panel.add( beginPanel );

		JLabel endLabel = new JLabel("Upper Bound");
		endText = new JTextField(3); 
		JPanel endPanel = new JPanel();
		endPanel.add( endLabel );
		endPanel.add( endText );
		endPanel.setLayout( new BoxLayout( endPanel, BoxLayout.Y_AXIS ) );
		endPanel.setBackground( Color.white );
		s1Panel.add( endPanel );

		boxes.add( s1Panel );

		add( boxes );

		addButton = new JButton("Add to List");
		//addButton.setActionCommand("add new score condition to list");
		addButton.addActionListener(this);
		add( addButton );

		setBorder(BorderFactory.createTitledBorder("Create a Score Filter"));
	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		setBackground(Color.white);
	}

	private float getNumber( JTextField field ) 
		throws Exception
	{
		float i = 0;
		try {
			i = Float.parseFloat( field.getText() );
		} catch ( NumberFormatException nfe )
		{
			throw new Exception("Invalid number specified in begin/end field"); 
		}

		return i;
	}

	public void clear()
	{
		beginText.setText("");
		endText.setText("");
	}

	public Condition create()
		throws Exception
	{
		String name = nameText.getText();

		float lb = getNumber( beginText );
		float lbper = lb * 100;
		float ub = getNumber( endText );
		float ubper = ub * 100;

		String desc = "Only display alignment if score >= " + 
		              Float.toString(lbper)  + "% of optimal and  score <= " + 
					  Float.toString(ubper) + "% of optimal";

		return new ScoreCondition(name, desc, lb, ub);
	}

	public void actionPerformed(ActionEvent e)
	{
		Condition c = null;
		try {
			c = create();
		} catch (Exception ex)
		{
			JOptionPane.showMessageDialog( this, ex.getMessage(),
                          "Filter Create ERROR", JOptionPane.ERROR_MESSAGE);
			ex.printStackTrace();
		}

		if ( c != null )
		{
			firePropertyChange("add new condition to list",null,c);
			clear();
		}
	}
}
